# Trendyol Seller Toolkit — Proje Yol Haritasi

## Vizyon
Trendyol saticilarinin urun arastirmasi, karlilik analizi ve rekabet takibi yapabilecegi **Jungle Scout benzeri** profesyonel bir arac. Chrome extension olarak baslayip, ileride SaaS platformuna donusecek.

---

## Mevcut Durum (v1.1.0)

### Tamamlanan Ozellikler
- **Karlilik Hesaplayici**: Komisyon, kargo, hizmet bedeli, KDV hesabi (Excel formulleriyle uyumlu)
- **Urun Detay Paneli**: Sag kenar cubugu — fiyat, komisyon, kargo, kar, maliyet, aylik kar tahmini
- **Listeleme Sayfasi Tablosu**: Dark overlay, 15+ sutun, siralama, CSV export
- **Kategori Tarayici**: 16 kategori otomatik tarama, en karli urunleri bulma
- **Stok Delta Takip**: 20 urune kadar, satici bazli stok izleme, EMA tabanli satis tahmini
- **Anomali Tespiti**: Pending verification sistemi (influencer vs stok dusurme ayrimi)
- **Coklu Kargo Firmasi**: TEX-PTT, Aras, Surat, Kolay Gelsin, DHL, Yurtici
- **Manuel Override**: Komisyon, kargo, maliyet, satis adedi, KDV orani
- **Hedef Kar %**: Kullanici hedef kar orani girer, maks maliyet otomatik hesaplanir

### Teknik Mimari
```
Extension (Manifest V3)
├── inject.js (MAIN world) — Trendyol React props okuma
├── content.js (ISOLATED) — Panel, tablo, hesaplama UI
├── calculator.js — Karlilik motoru
├── background.js — Stok takip, kategori tarama, mesaj yonlendirme
├── popup/ — Ayarlar, takip listesi, tarayici
└── data/ — Komisyon ve kargo tablolari
```

### Bilinen Sorunlar / Teknik Borc
- web/ klasoru (bookmarklet, tampermonkey) eski hesaplama formullerini kullaniyor — guncellenmedi
- Komisyon tablosu statik (PDF'den manuel girilmis) — otomasyon yok
- Kargo tablolari statik — Trendyol fiyat degisikliklerinde manuel guncelleme gerekiyor
- Popup UI basit — detayli grafik/chart yok

---

## Gelistirme Asamalari

### Faz 1 — Temel Saglamlastirma (Mevcut)
> Oncelik: Mevcut ozellikleri stabil ve guvenilir hale getir

- [x] Karlilik hesabi Excel ile birebir uyumlu
- [x] Komisyon KDV dahil fiyat uzerinden, karlilik KDV haric
- [x] Kargo tablolari KDV haric (dogrudan base deger)
- [x] Hedef kar % input ve maks maliyet hesabi
- [x] Stok takip sistemi (20 urun, satici bazli delta)
- [x] Race condition duzeltmesi (storage yazma cakismasi)
- [x] Cache-buster (CDN bypass) stok fetch'lerde
- [ ] web/ klasoru guncelleme veya kaldir
- [ ] Error handling iyilestirme (fetch hatalari, timeout)
- [ ] Stok takip loglarini popup'ta gosterme (debug panel)

### Faz 2 — Urun Arastirma Motoru
> Oncelik: Jungle Scout'un "Product Database" benzeri ozellik

- [ ] **Gelismis Kategori Tarayici**
  - Tum Trendyol kategorilerini otomatik kesfet (sadece 16 degil, 200+)
  - Filtreler: fiyat araligi, yorum sayisi, satis tahmini, kar marji
  - Pagination destegi (simdi sadece ilk sayfa)
  - Tarama sonuclarini kaydet ve karsilastir (tarihsel)

- [ ] **Urun Skor Sistemi**
  - Her urune 0-100 "firsat skoru" ver
  - Kriterler: kar marji, rekabet (satici sayisi), talep (satis hizi), trend
  - Renk kodlu skorlama (yesil/sari/kirmizi)

- [ ] **Niche Bulucu**
  - Dusuk rekabet + yuksek talep kombinasyonu
  - Alt kategori bazli analiz
  - "Mavi okyanus" urun onerileri

- [ ] **Trend Analizi**
  - Fiyat gecmisi grafigi (stok takipteki urunler icin)
  - Sezonluk talep degisimi
  - Yeni eklenen urunlerin performansi

### Faz 3 — Rekabet Analizi
> Oncelik: Jungle Scout'un "Competitor Tracker" benzeri

- [ ] **Satici Profili**
  - Satici puan, urun sayisi, kategori dagilimi
  - Buybox kazanma orani
  - Fiyat stratejisi analizi

- [ ] **Fiyat Izleme**
  - Rakip fiyat degisikliklerini takip et
  - Fiyat alarm sistemi (belirlenen esik degerinde bildirim)
  - Fiyat gecmisi grafigi

- [ ] **Buybox Takip**
  - Hangi satici ne zaman buybox kazaniyor
  - Fiyat farki ve buybox iliskisi
  - Buybox kaybetme alarmi

- [ ] **Listing Kalitesi Analizi**
  - Baslik uzunlugu, anahtar kelime sayisi
  - Gorsel sayisi ve kalitesi
  - Yorum sayisi ve ortalama puan
  - Iyilestirme onerileri

### Faz 4 — Bildirim ve Otomasyon
> Oncelik: Proaktif uyarilar ve otomatik aksiyonlar

- [ ] **Bildirim Sistemi**
  - Chrome push notification
  - Stok dusme alarmi (belirlenen esik)
  - Fiyat degisikligi alarmi
  - Yeni rakip girisi alarmi
  - Gunluk/haftalik ozet rapor

- [ ] **Dashboard**
  - Popup yerine tam sayfa dashboard (new tab)
  - Takip edilen urunlerin ozet goruntuleme
  - Grafik ve chartlar (satis trendi, stok grafigi)
  - Kar/zarar ozeti

- [ ] **Otomatik Raporlama**
  - Haftalik performans raporu (PDF/Excel export)
  - Kategori bazli analiz raporu
  - Rakip karsilastirma raporu

### Faz 5 — SaaS Donusumu
> Oncelik: Ucretsiz modelden ucretli modele gecis

- [ ] **Backend Altyapi**
  - Node.js/Python API server
  - Veritabani (PostgreSQL) — kullanici verileri, tarihsel data
  - Zamanlanmis gorevler (cron) — toplu stok/fiyat tarama
  - Rate limiting ve kuyruk yonetimi

- [ ] **Kullanici Sistemi**
  - Kayit / giris (email + Google OAuth)
  - Ucretsiz plan: 5 urun takip, gunluk 1 tarama
  - Pro plan: 50 urun, saatlik tarama, bildirimler, raporlar
  - Business plan: 200 urun, API erisimi, toplu islemler

- [ ] **Web Dashboard**
  - React/Next.js frontend
  - Responsive (mobil uyumlu)
  - Gercek zamanli veri (WebSocket)

- [ ] **Odeme Entegrasyonu**
  - Stripe veya iyzico
  - Aylik/yillik abonelik
  - Deneme suresi (14 gun)

### Faz 6 — Ileri Seviye Ozellikler
> Oncelik: Rekabetci avantaj ve kullanici bagliligi

- [ ] **Trendyol Satici Panel Entegrasyonu**
  - Satici panelinden gercek satis verileri (opsiyonel, kullanici izniyle)
  - Siparis takibi
  - Stok yonetimi onerileri

- [ ] **Anahtar Kelime Araci**
  - Trendyol arama hacmi tahmini
  - Anahtar kelime onerileri
  - Listing optimizasyon skoru
  - Rakip anahtar kelime analizi

- [ ] **Maliyet Hesaplayici Pro**
  - Tedarikci fiyat karsilastirma
  - Kargo optimizasyonu (desi vs barem secimi)
  - Kar simülasyonu (farkli fiyat senaryolari)
  - Break-even analizi

- [ ] **Toplu Islemler**
  - CSV/Excel ile toplu urun analizi
  - Toplu fiyat karsilastirma
  - Portfoy yonetimi (tum urunlerinin kar ozeti)

---

## Dosya Yapisi

```
trendyolchrome/
├── manifest.json              — Extension yapilandirma (v3)
├── CLAUDE.md                  — Bu dosya (yol haritasi)
│
├── background/
│   └── background.js          — Service worker (stok takip, kategori tarama, mesajlasma)
│
├── content/
│   ├── inject.js              — MAIN world (Trendyol React props okuma)
│   ├── content.js             — ISOLATED world (panel, tablo, tum UI)
│   └── content.css            — Tum stil tanimlari
│
├── data/
│   ├── commissions.js         — Komisyon orani tablosu (kategori → %)
│   └── shipping.js            — Kargo ucret tablosu (KDV haric base fiyatlar)
│
├── utils/
│   └── calculator.js          — Karlilik hesaplama motoru
│
├── popup/
│   ├── popup.html             — Extension popup UI + CSS
│   └── popup.js               — Popup mantigi (ayarlar, takip listesi)
│
├── icons/                     — Extension ikonlari (16, 48, 128 px)
│
└── web/                       — Eski: bookmarklet/tampermonkey versiyonlari (guncel degil)
```

## Hesaplama Formulleri

### Karlilik Hesabi (KDV Haric)
```
Satis Fiyati (KDV Haric) = Satis Fiyati / (1 + KDV%)
Komisyon (KDV Dahil)     = Satis Fiyati × Komisyon%     ← Trendyol kurali
Komisyon (KDV Haric)     = Komisyon (KDV Dahil) / (1 + KDV%)
Hizmet Bedeli (KDV Haric)= 10.20 / (1 + KDV%)
Kargo (KDV Haric)        = Tablo degeri (zaten KDV haric, dokunma)
Hesaba Gececek            = Satis(KDV H) - Komisyon(KDV H) - Hizmet(KDV H) - Kargo
Kar                       = Hesaba Gececek - Maliyet
Kar Marji                 = Kar / Hesaba Gececek × 100
Maks Maliyet              = Hesaba Gececek × (1 - Hedef Kar%)
```

### Onemli Kurallar
- Komisyon: KDV **dahil** fiyat uzerinden kesilir
- Kargo: Tablo degerleri zaten KDV **haric** — ekstra KDV islemi yok
- Hizmet bedeli: Sabit 10.20 TL (KDV dahil)
- Panel gosterimi: Tum kalemler KDV haric

## Stok Takip Sistemi

### Mimari
- chrome.alarms ile 60dk periyodik (gunduz), gece 00:00 + 04:00
- Buybox + en yakin 2 satici stok takibi (satici bazli delta)
- EMA tabanli satis hizi hesabi (alpha=0.3)
- Anomali tespiti: 5x beklenen hiz veya %30+ stok dususu → pending_verification
- Dogrulama: 3 sonraki olcumde hiz devam ediyorsa → gercek satis, yoksa → stok ayarlamasi

### Veri Yapisi (stockTracking)
```
products[id] = {
  readings: [{ts, totalStock, price, merchants: {mid: qty}}],
  events: [{ts, type, sold, prevStock, newStock, merchantDeltas}],
  dailySummaries: {dateKey: {totalSold, readingCount, ...}},
  estimates: {hourlyRate, dailyEstimate, weeklyEstimate, monthlyEstimate},
  confidence: {level, label, daysTracked, saleEvents}
}
```

## Gelistirme Kurallari

### Kodlama Standartlari
- Vanilla JS (framework yok) — extension boyutunu kucuk tut
- Turkce degisken isimleri ve yorumlar kabul edilir (UI Turkce)
- Her fonksiyon basinda kisa aciklama yorumu
- console.log prefix: `[TK-STOCK]`, `[TK-BG]`, `[TK-POPUP]` vb.

### Storage Kurallari
- **OKUMA fonksiyonlari (getTrackedProducts vb.) asla storage'a YAZMAMALI** — race condition riski
- Storage yazma: sadece explicit guncelleme fonksiyonlarinda, tek seferde
- Buyuk veri: `chrome.storage.local` (unlimitedStorage izni var)
- Ayarlar: `chrome.storage.sync` (cihazlar arasi senkron)

### Test / Debug
- Extension konsolu: chrome://extensions > service worker > Inspect
- Content script konsolu: Trendyol sayfasinda F12 > Console
- Stok takip: `[TK-STOCK]` prefix'li loglar service worker konsolunda
- Race condition: storage yazma islemlerini her zaman logla

### Commit Kurallari
- Feature branch: `feat/ozellik-adi`
- Bug fix: `fix/sorun-aciklamasi`
- Turkce commit mesajlari kabul edilir
