// ═══════════════════════════════════════════════════════════════════
//  Trendyol Karlılık Hesaplayıcı — MAIN World Inject Script
// ═══════════════════════════════════════════════════════════════════
//  Bu script "MAIN" world'de çalışır ve sayfa JS değişkenlerine
//  doğrudan erişebilir. Okunan veriyi DOM'a yazar, content script
//  (ISOLATED world) oradan okur.
//
//  Manifest'te world: "MAIN" olarak tanımlanır → CSP sorunu yaşamaz.
// ═══════════════════════════════════════════════════════════════════

(function () {
  "use strict";

  function readPageData() {
    var result = {};

    // ─── Detay Sayfası: __envoy_product-detail__PROPS ───
    try {
      var dp = window["__envoy_product-detail__PROPS"];
      if (dp && dp.product) {
        var p = dp.product;
        // merchantListing kısayolu
        var ml = p.merchantListing || {};
        // winnerVariant kısayolu
        var wv = (ml.winnerVariant) || null;
        var wvPrice = (wv && wv.price) || null;

        // Satıcı bilgisi
        var merchant = (ml.merchant) || null;
        // Promosyonlar
        var promos = (ml.promotions) || [];
        var promoList = promos.map(function (pr) {
          return {
            name: pr.name || "",
            type: pr.promotionDiscountType || "",
            endDate: pr.promotionEndDate || null,
            remainingDays: pr.promotionRemainingDays
          };
        });

        result.detailProduct = {
          id: p.id,
          favoriteCount: p.favoriteCount || 0,
          ratingScore: p.ratingScore || null,
          categoryHierarchy:
            (p.category && p.category.hierarchy) || null,
          // Kategori ağacı (ID + isim) — komisyon eşleştirmesi için
          // NOT: Trendyol webCategoryTree'yi TERS sırada verir (alt→üst).
          // Doğru sıra: üst→alt (ör: Süpermarket > Temizlik > Temizlik Bezleri)
          categoryTree: (p.webCategoryTree || []).map(function (c) {
            return { id: c.id, name: c.name };
          }).reverse(),
          categoryId: (p.category && p.category.id) || null,
          stockQuantity: (wv && wv.quantity) || 0,
          maxSaleLimit: (wv && wv.maxSaleLimit) || 0,
          isRunningOut: (wv && wv.isRunningOut) || false,
          freeCargo: (wv && wv.freeCargo) || false,
          categoryTopRankings: p.categoryTopRankings || [],
          // Fiyat bilgisi (çok satıcılı sayfalar dahil — DOM'da fiyat olmayabilir)
          sellingPrice:
            (wvPrice && wvPrice.sellingPrice && wvPrice.sellingPrice.value) || 0,
          discountedPrice:
            (wvPrice && wvPrice.discountedPrice && wvPrice.discountedPrice.value) || 0,
          originalPrice:
            (wvPrice && wvPrice.originalPrice && wvPrice.originalPrice.value) || 0,
          // Trendyol Plus fiyatı (tyPlusCouponApplicablePrice — Plus üyelere özel sepet fiyatı)
          plusPrice:
            (wvPrice && wvPrice.tyPlusCouponApplicablePrice && wvPrice.tyPlusCouponApplicablePrice.value) || 0,
          // Plus uygunluk (isTyPlusEligible = true ise gerçek Plus indirim var)
          isTyPlusEligible: (wv && wv.isTyPlusEligible) || false,
          // KDV oranı (gerçek — Trendyol backend'inden)
          taxRate: p.tax || 0,
          // Satıcı bilgisi
          seller: merchant
            ? {
                name: merchant.name || "",
                id: merchant.id || 0,
                score: merchant.sellerScore
                  ? merchant.sellerScore.value
                  : 0,
                officialName: merchant.officialName || "",
              }
            : null,
          // Promosyonlar / kampanyalar
          promotions: promoList,
          // Diğer satıcılar (merchantListing.otherMerchants)
          otherMerchants: (ml.otherMerchants || []).map(function (om) {
            var omVariant = (om.variants && om.variants[0]) || null;
            return {
              id: om.id || 0,
              name: om.name || "",
              stock: omVariant ? (omVariant.quantity || 0) : 0,
              price: omVariant && omVariant.price
                ? (omVariant.price.discountedPrice && omVariant.price.discountedPrice.value) ||
                  (omVariant.price.sellingPrice && omVariant.price.sellingPrice.value) || 0
                : 0,
            };
          }),
        };
      }
    } catch (e) {
      // silent
    }

    // ─── Listing Sayfası: __single-search-result__PROPS ───
    try {
      var sp = window["__single-search-result__PROPS"];
      if (sp && sp.data && sp.data.products) {
        result.listingProducts = sp.data.products.map(function (pr) {
          return {
            id: pr.id,
            socialProof: pr.socialProof || [],
            ratingScore: pr.ratingScore || null,
            // Havuza ekleme için temel ürün bilgileri
            url: pr.url || null,
            name: pr.name || null,
            brand: (pr.brand && pr.brand.name) ? pr.brand.name : (typeof pr.brand === 'string' ? pr.brand : null),
            price: pr.price ? (pr.price.discountedPrice || pr.price.current || pr.price.sellingPrice || (typeof pr.price === 'number' ? pr.price : null)) : null,
            image: pr.image || null,
            merchantId: pr.merchantId || null,
            category: pr.category || null,
          };
        });
      }
    } catch (e) {
      // silent
    }

    return result;
  }

  // Veriyi DOM'a yaz + timestamp ekle (cache kontrolü için)
  function writeToDOM(data) {
    data._ts = Date.now();
    data._url = window.location.href;
    var el = document.getElementById("tk-page-data");
    if (!el) {
      el = document.createElement("div");
      el.id = "tk-page-data";
      el.style.display = "none";
      document.documentElement.appendChild(el);
    }
    el.textContent = JSON.stringify(data);
    // Content script'e hazır olduğunu bildir (custom event)
    document.dispatchEvent(new CustomEvent("tk-page-data-ready"));
  }

  function run() {
    var data = readPageData();
    // Boş veri yazma — en azından bir şey bulunmalı
    if (data.detailProduct || data.listingProducts) {
      writeToDOM(data);
    }
  }

  // İlk çalıştırma — birkaç kez dene (props geç yüklenebilir)
  function initialRun() {
    run();
    setTimeout(run, 300);
    setTimeout(run, 800);
    setTimeout(run, 1500);
    setTimeout(run, 3000);
  }

  if (document.readyState === "complete" || document.readyState === "interactive") {
    initialRun();
  } else {
    document.addEventListener("DOMContentLoaded", initialRun);
  }

  // SPA navigasyon takibi — URL değişince yeniden oku
  var lastURL = window.location.href;
  setInterval(function () {
    if (window.location.href !== lastURL) {
      lastURL = window.location.href;
      // Eski veriyi temizle (stale data prevention)
      var el = document.getElementById("tk-page-data");
      if (el) el.textContent = "{}";
      // Yeni sayfa verisi yüklenene kadar birkaç kez dene
      setTimeout(run, 500);
      setTimeout(run, 1000);
      setTimeout(run, 2000);
      setTimeout(run, 3500);
    }
  }, 500);

  // Content script'ten gelen "yeniden oku" isteğini dinle
  document.addEventListener("tk-page-data-refresh", function () {
    run();
  });
})();
