// Panel Bridge — app.tpro360.com ile extension background arasinda kopru
// Research sayfasi window.postMessage ile socialProof istegi gonderir,
// bu script background'a iletir ve sonucu geri dondurur.

(function() {
  // Extension varligini bildiren marker
  window.postMessage({ type: 'TPRO_EXTENSION_READY' }, '*');

  window.addEventListener('message', async (event) => {
    // Sadece ayni origin'den gelen mesajlari isle
    if (event.source !== window) return;
    if (!event.data || event.data.type !== 'TPRO_REQUEST') return;

    const { requestId, action, payload } = event.data;
    if (!requestId || !action) return;

    try {
      // Background'a ilet
      const response = await chrome.runtime.sendMessage({
        action,
        ...payload
      });

      window.postMessage({
        type: 'TPRO_RESPONSE',
        requestId,
        success: true,
        data: response
      }, '*');
    } catch (err) {
      window.postMessage({
        type: 'TPRO_RESPONSE',
        requestId,
        success: false,
        error: err.message
      }, '*');
    }
  });
})();
