// Trendyol Komisyon Oranları Tablosu (Güncel - KDV Dahil)
// Base Kategori Komisyon % kullanılmaktadır
// Kaynak: guncel_trendyol_komisyon_oranlari.pdf

const TRENDYOL_COMMISSIONS = [
  // ===== AKSESUAR =====
  { kategori: "Aksesuar", altKategori: "Altın", urunGrubu: "İşlenmemiş", vade: 21, komisyon: 9.00 },
  { kategori: "Aksesuar", altKategori: "Altın", urunGrubu: "İşlenmiş", vade: 21, komisyon: 9.00 },
  { kategori: "Aksesuar", altKategori: "Mücevher", urunGrubu: "Mücevher", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Atkı & Bere & Eldiven", urunGrubu: "Atkı & Bere & Eldiven", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Gözlük", urunGrubu: "Güneş Gözlüğü", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Gözlük", urunGrubu: "Optik Gözlük", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Saat", urunGrubu: "Kol Saati", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Saat", urunGrubu: "Akıllı Saat", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Şapka & Kep", urunGrubu: "Şapka & Kep", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Kemer", urunGrubu: "Kemer", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Cüzdan", urunGrubu: "Cüzdan", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Takı", urunGrubu: "Kolye", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Takı", urunGrubu: "Bileklik", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Takı", urunGrubu: "Küpe", vade: 21, komisyon: 21.50 },
  { kategori: "Aksesuar", altKategori: "Takı", urunGrubu: "Yüzük", vade: 21, komisyon: 21.50 },

  // ===== AYAKKABI & ÇANTA =====
  { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Kadın Ayakkabı", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Erkek Ayakkabı", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Çocuk Ayakkabı", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Spor Ayakkabı", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Sneaker", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Bot", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Sandalet", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Terlik", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Topuklu Ayakkabı", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Çanta", urunGrubu: "Kadın Çanta", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Çanta", urunGrubu: "Erkek Çanta", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Çanta", urunGrubu: "Sırt Çantası", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Çanta", urunGrubu: "Bavul & Valiz", vade: 21, komisyon: 21.50 },
  { kategori: "Ayakkabı & Çanta", altKategori: "Çanta", urunGrubu: "El Çantası", vade: 21, komisyon: 21.50 },

  // ===== BAHÇE & ELEKTRİKLİ EL ALETLERİ =====
  { kategori: "Yapı Market & Bahçe", altKategori: "Bahçe", urunGrubu: "Bahçe Aydınlatması", vade: 21, komisyon: 20.50 },
  { kategori: "Yapı Market & Bahçe", altKategori: "Bahçe", urunGrubu: "Bahçe Makineleri", vade: 21, komisyon: 16.00 },
  { kategori: "Yapı Market & Bahçe", altKategori: "Bahçe", urunGrubu: "Bahçe Mobilyası", vade: 21, komisyon: 20.50 },
  { kategori: "Yapı Market & Bahçe", altKategori: "Bahçe", urunGrubu: "Bahçe Süsleme", vade: 21, komisyon: 20.50 },
  { kategori: "Yapı Market & Bahçe", altKategori: "Elektrikli El Aletleri", urunGrubu: "Elektrikli El Aletleri", vade: 21, komisyon: 16.50 },
  { kategori: "Yapı Market & Bahçe", altKategori: "Hırdavat", urunGrubu: "Hırdavat", vade: 21, komisyon: 20.50 },
  { kategori: "Yapı Market & Bahçe", altKategori: "Boya & Yapı Kimyasalları", urunGrubu: "Boya", vade: 21, komisyon: 20.50 },
  { kategori: "Yapı Market & Bahçe", altKategori: "Tesisat", urunGrubu: "Tesisat Malzemeleri", vade: 21, komisyon: 20.50 },

  // ===== ELEKTRONİK =====
  { kategori: "Elektronik", altKategori: "Akıllı Ev", urunGrubu: "Akıllı Aydınlatma Ürünleri", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Akıllı Ev", urunGrubu: "Akıllı Ev Sistemleri", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Telefon", urunGrubu: "Smartphone Android", vade: 14, komisyon: 7.00 },
  { kategori: "Elektronik", altKategori: "Telefon", urunGrubu: "Smartphone iOS", vade: 14, komisyon: 7.00 },
  { kategori: "Elektronik", altKategori: "Telefon", urunGrubu: "Cep Telefonu", vade: 14, komisyon: 7.00 },
  { kategori: "Elektronik", altKategori: "Telefon Aksesuarları", urunGrubu: "Telefon Kılıfı", vade: 14, komisyon: 21.50 },
  { kategori: "Elektronik", altKategori: "Telefon Aksesuarları", urunGrubu: "Şarj Aleti", vade: 14, komisyon: 21.50 },
  { kategori: "Elektronik", altKategori: "Telefon Aksesuarları", urunGrubu: "Ekran Koruyucu", vade: 14, komisyon: 21.50 },
  { kategori: "Elektronik", altKategori: "Telefon Aksesuarları", urunGrubu: "Kulaklık", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Telefon Aksesuarları", urunGrubu: "Powerbank", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Beyaz Eşya", urunGrubu: "Buzdolabı", vade: 14, komisyon: 15.00 },
  { kategori: "Elektronik", altKategori: "Beyaz Eşya", urunGrubu: "Çamaşır Makinesi", vade: 14, komisyon: 15.00 },
  { kategori: "Elektronik", altKategori: "Beyaz Eşya", urunGrubu: "Bulaşık Makinesi", vade: 14, komisyon: 15.00 },
  { kategori: "Elektronik", altKategori: "Beyaz Eşya", urunGrubu: "Fırın", vade: 14, komisyon: 15.00 },
  { kategori: "Elektronik", altKategori: "TV", urunGrubu: "Televizyon", vade: 14, komisyon: 15.00 },
  { kategori: "Elektronik", altKategori: "TV", urunGrubu: "TV Aksesuarları", vade: 14, komisyon: 15.00 },
  { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Laptop", vade: 14, komisyon: 11.00 },
  { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Masaüstü Bilgisayar", vade: 14, komisyon: 11.00 },
  { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Tablet", vade: 14, komisyon: 11.00 },
  { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Bilgisayar Aksesuarları", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Monitör", vade: 14, komisyon: 11.00 },
  { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Yazıcı", vade: 14, komisyon: 11.00 },
  { kategori: "Elektronik", altKategori: "Klima", urunGrubu: "Klima", vade: 14, komisyon: 11.00 },
  { kategori: "Elektronik", altKategori: "Klima", urunGrubu: "Isıtıcı", vade: 14, komisyon: 15.00 },
  { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Ütü", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Elektrikli Süpürge", vade: 14, komisyon: 15.00 },
  { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Çay Makinesi", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Kahve Makinesi", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Robot Süpürge", vade: 14, komisyon: 15.00 },
  { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Blender", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Mutfak Robotu", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Tost Makinesi", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Saç Kurutma", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Saç Düzleştirici", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Kamera", urunGrubu: "Fotoğraf Makinesi", vade: 14, komisyon: 11.00 },
  { kategori: "Elektronik", altKategori: "Kamera", urunGrubu: "Aksiyon Kamera", vade: 14, komisyon: 11.00 },
  { kategori: "Elektronik", altKategori: "Kamera", urunGrubu: "Güvenlik Kamerası", vade: 14, komisyon: 19.50 },
  { kategori: "Elektronik", altKategori: "Oyun", urunGrubu: "Oyun Konsolu", vade: 14, komisyon: 11.00 },
  { kategori: "Elektronik", altKategori: "Oyun", urunGrubu: "Oyun Aksesuarları", vade: 14, komisyon: 19.50 },

  // ===== ÇOCUK & BEBEK =====
  { kategori: "Çocuk & Bebek", altKategori: "Bebek", urunGrubu: "Bebek Arabası", vade: 21, komisyon: 19.00 },
  { kategori: "Çocuk & Bebek", altKategori: "Bebek", urunGrubu: "Bebek Gereçleri", vade: 21, komisyon: 19.00 },
  { kategori: "Çocuk & Bebek", altKategori: "Bebek", urunGrubu: "Bebek Bezi", vade: 21, komisyon: 14.00 },
  { kategori: "Çocuk & Bebek", altKategori: "Bebek", urunGrubu: "Bebek Bakım", vade: 21, komisyon: 19.00 },
  { kategori: "Çocuk & Bebek", altKategori: "Bebek", urunGrubu: "Bebek Giyim", vade: 21, komisyon: 21.50 },
  { kategori: "Çocuk & Bebek", altKategori: "Çocuk", urunGrubu: "Çocuk Giyim", vade: 21, komisyon: 21.50 },
  { kategori: "Çocuk & Bebek", altKategori: "Çocuk", urunGrubu: "Çocuk Ayakkabı", vade: 21, komisyon: 21.50 },
  { kategori: "Çocuk & Bebek", altKategori: "Oyuncak", urunGrubu: "Oyuncak Genel", vade: 21, komisyon: 19.00 },
  { kategori: "Çocuk & Bebek", altKategori: "Oyuncak", urunGrubu: "Oyuncak Ahşap", vade: 21, komisyon: 19.00 },
  { kategori: "Çocuk & Bebek", altKategori: "Oyuncak", urunGrubu: "Eğitici Oyuncak", vade: 21, komisyon: 19.00 },
  { kategori: "Çocuk & Bebek", altKategori: "Çocuk Gereçleri", urunGrubu: "Çocuk Gereçleri", vade: 21, komisyon: 19.00 },
  { kategori: "Çocuk & Bebek", altKategori: "Oto Koltuğu", urunGrubu: "Oto Koltuğu", vade: 3, komisyon: 19.00 },

  // ===== GİYİM =====
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Elbise", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Bluz", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Gömlek", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Tişört", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Pantolon", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Jean", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Etek", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Ceket", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Mont", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Kazak", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Hırka", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Sweatshirt", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Yelek", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Trençkot", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Tayt", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Eşofman", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Tişört", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Gömlek", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Pantolon", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Jean", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Ceket", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Mont", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Kazak", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Sweatshirt", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Takım Elbise", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Şort", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Eşofman", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Spor Giyim", urunGrubu: "Spor Giyim", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "İç Giyim", urunGrubu: "Kadın İç Giyim", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "İç Giyim", urunGrubu: "Erkek İç Giyim", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "İç Giyim", urunGrubu: "Pijama", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "İç Giyim", urunGrubu: "Çorap", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Büyük Beden", urunGrubu: "Büyük Beden Giyim", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Hamile Giyim", urunGrubu: "Hamile Giyim", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Tesettür", urunGrubu: "Tesettür Giyim", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Mayo & Bikini", urunGrubu: "Mayo & Bikini", vade: 21, komisyon: 21.50 },
  { kategori: "Giyim", altKategori: "Gelinlik", urunGrubu: "Gelinlik & Abiye", vade: 21, komisyon: 21.50 },

  // ===== EV & MOBİLYA =====
  { kategori: "Ev & Mobilya", altKategori: "Mobilya", urunGrubu: "Salon Mobilyası", vade: 28, komisyon: 23.00 },
  { kategori: "Ev & Mobilya", altKategori: "Mobilya", urunGrubu: "Yatak Odası", vade: 28, komisyon: 23.00 },
  { kategori: "Ev & Mobilya", altKategori: "Mobilya", urunGrubu: "Ofis Mobilyası", vade: 28, komisyon: 23.00 },
  { kategori: "Ev & Mobilya", altKategori: "Mobilya", urunGrubu: "Mutfak Mobilyası", vade: 28, komisyon: 23.00 },
  { kategori: "Ev & Mobilya", altKategori: "Mobilya", urunGrubu: "Banyo Mobilyası", vade: 28, komisyon: 23.00 },
  { kategori: "Ev & Mobilya", altKategori: "Mobilya", urunGrubu: "Çocuk Odası", vade: 28, komisyon: 23.00 },
  { kategori: "Ev & Mobilya", altKategori: "Yatak", urunGrubu: "Yatak", vade: 28, komisyon: 23.00 },
  { kategori: "Ev & Mobilya", altKategori: "Yatak", urunGrubu: "Baza", vade: 28, komisyon: 23.00 },
  { kategori: "Ev & Mobilya", altKategori: "Ev Tekstili", urunGrubu: "Nevresim", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Ev Tekstili", urunGrubu: "Yastık", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Ev Tekstili", urunGrubu: "Yorgan", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Ev Tekstili", urunGrubu: "Havlu", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Ev Tekstili", urunGrubu: "Perde", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Ev Tekstili", urunGrubu: "Halı", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Ev Tekstili", urunGrubu: "Battaniye", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Mutfak", urunGrubu: "Tencere & Tava", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Mutfak", urunGrubu: "Bıçak Seti", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Mutfak", urunGrubu: "Mutfak Gereçleri", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Mutfak", urunGrubu: "Tabak & Kase", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Mutfak", urunGrubu: "Bardak", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Dekorasyon", urunGrubu: "Duvar Dekorasyon", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Dekorasyon", urunGrubu: "Mum & Aroma", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Dekorasyon", urunGrubu: "Vazo", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Dekorasyon", urunGrubu: "Ayna", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Aydınlatma", urunGrubu: "Avize", vade: 21, komisyon: 20.50 },
  { kategori: "Ev & Mobilya", altKategori: "Aydınlatma", urunGrubu: "Lamba", vade: 21, komisyon: 20.50 },
  { kategori: "Ev & Mobilya", altKategori: "Banyo", urunGrubu: "Banyo Aksesuarları", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Ev Organizasyon", urunGrubu: "Saklama Kutuları", vade: 21, komisyon: 21.50 },
  { kategori: "Ev & Mobilya", altKategori: "Ev Organizasyon", urunGrubu: "Ütü Masası", vade: 21, komisyon: 21.50 },

  // ===== KOZMETİK & KİŞİSEL BAKIM =====
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Makyaj", urunGrubu: "Ruj", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Makyaj", urunGrubu: "Fondöten", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Makyaj", urunGrubu: "Maskara", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Makyaj", urunGrubu: "Göz Farı", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Makyaj", urunGrubu: "Oje", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Cilt Bakımı", urunGrubu: "Nemlendirici", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Cilt Bakımı", urunGrubu: "Güneş Kremi", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Cilt Bakımı", urunGrubu: "Temizleyici", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Cilt Bakımı", urunGrubu: "Serum", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Saç Bakımı", urunGrubu: "Şampuan", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Saç Bakımı", urunGrubu: "Saç Kremi", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Saç Bakımı", urunGrubu: "Saç Boyası", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Parfüm", urunGrubu: "Kadın Parfüm", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Parfüm", urunGrubu: "Erkek Parfüm", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Parfüm", urunGrubu: "Deodorant", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Kişisel Bakım", urunGrubu: "Diş Bakımı", vade: 21, komisyon: 20.00 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Kişisel Bakım", urunGrubu: "Tıraş", vade: 21, komisyon: 20.00 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Kişisel Bakım", urunGrubu: "Duş Jeli", vade: 21, komisyon: 21.50 },
  { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Kişisel Bakım", urunGrubu: "El Kremi", vade: 21, komisyon: 21.50 },

  // ===== SPOR & OUTDOOR =====
  { kategori: "Spor & Outdoor", altKategori: "Spor Giyim", urunGrubu: "Spor Tişört", vade: 21, komisyon: 21.50 },
  { kategori: "Spor & Outdoor", altKategori: "Spor Giyim", urunGrubu: "Spor Tayt", vade: 21, komisyon: 21.50 },
  { kategori: "Spor & Outdoor", altKategori: "Spor Giyim", urunGrubu: "Eşofman Takımı", vade: 21, komisyon: 21.50 },
  { kategori: "Spor & Outdoor", altKategori: "Spor Ekipman", urunGrubu: "Fitness Ekipmanı", vade: 21, komisyon: 19.00 },
  { kategori: "Spor & Outdoor", altKategori: "Spor Ekipman", urunGrubu: "Bisiklet", vade: 21, komisyon: 16.00 },
  { kategori: "Spor & Outdoor", altKategori: "Spor Ekipman", urunGrubu: "Kamp Malzemeleri", vade: 21, komisyon: 19.00 },
  { kategori: "Spor & Outdoor", altKategori: "Spor Ekipman", urunGrubu: "Outdoor", vade: 21, komisyon: 19.00 },
  { kategori: "Spor & Outdoor", altKategori: "Spor Ayakkabı", urunGrubu: "Koşu Ayakkabısı", vade: 21, komisyon: 21.50 },
  { kategori: "Spor & Outdoor", altKategori: "Spor Ayakkabı", urunGrubu: "Futbol Ayakkabısı", vade: 21, komisyon: 21.50 },
  { kategori: "Spor & Outdoor", altKategori: "Spor Ayakkabı", urunGrubu: "Basketbol Ayakkabısı", vade: 21, komisyon: 21.50 },

  // ===== SÜPERMARKET =====
  // Kaynak: Trendyol Güncel Komisyon Tablosu (Excel)
  // Gıda & İçecek
  { kategori: "Süpermarket", altKategori: "Gıda", urunGrubu: "Atıştırmalık", vade: 28, komisyon: 18.00 },
  { kategori: "Süpermarket", altKategori: "Gıda", urunGrubu: "Çikolata & Şekerleme", vade: 28, komisyon: 18.00 },
  { kategori: "Süpermarket", altKategori: "Gıda", urunGrubu: "Kahvaltılık", vade: 28, komisyon: 18.00 },
  { kategori: "Süpermarket", altKategori: "Gıda", urunGrubu: "Bakliyat & Makarna", vade: 28, komisyon: 13.00 },
  { kategori: "Süpermarket", altKategori: "Gıda", urunGrubu: "Baharat", vade: 28, komisyon: 18.00 },
  { kategori: "Süpermarket", altKategori: "Gıda & İçecek", urunGrubu: "Dökme Çay", vade: 28, komisyon: 13.00 },
  { kategori: "Süpermarket", altKategori: "Gıda & İçecek", urunGrubu: "Enerji İçeceği", vade: 28, komisyon: 19.00 },
  { kategori: "Süpermarket", altKategori: "Gıda & İçecek", urunGrubu: "Filtre ve Çekirdek Kahve", vade: 28, komisyon: 17.00 },
  { kategori: "Süpermarket", altKategori: "İçecek", urunGrubu: "Çay", vade: 28, komisyon: 13.00 },
  { kategori: "Süpermarket", altKategori: "İçecek", urunGrubu: "Kahve", vade: 28, komisyon: 17.00 },
  { kategori: "Süpermarket", altKategori: "İçecek", urunGrubu: "Su & Maden Suyu", vade: 28, komisyon: 13.00 },
  { kategori: "Süpermarket", altKategori: "İçecek", urunGrubu: "Meyve Suyu", vade: 28, komisyon: 18.00 },
  // Ev Bakım ve Temizlik (Güncel: %17 — Ev ve Temizlik Gereçleri üst kategori oranı)
  { kategori: "Süpermarket", altKategori: "Ev Bakım ve Temizlik", urunGrubu: "Ev ve Temizlik Gereçleri", vade: 28, komisyon: 17.00 },
  { kategori: "Süpermarket", altKategori: "Ev Bakım ve Temizlik", urunGrubu: "Temizlik Gereçleri", vade: 28, komisyon: 17.00 },
  { kategori: "Süpermarket", altKategori: "Ev Bakım ve Temizlik", urunGrubu: "Tüy Toplayıcı", vade: 28, komisyon: 17.00 },
  { kategori: "Süpermarket", altKategori: "Ev Bakım ve Temizlik", urunGrubu: "Ev Temizlik Ürünleri", vade: 28, komisyon: 17.00 },
  { kategori: "Süpermarket", altKategori: "Ev Bakım ve Temizlik", urunGrubu: "Çamaşır Deterjanı", vade: 28, komisyon: 17.00 },
  { kategori: "Süpermarket", altKategori: "Ev Bakım ve Temizlik", urunGrubu: "Bulaşık Deterjanı", vade: 28, komisyon: 16.00 },
  { kategori: "Süpermarket", altKategori: "Ev Bakım ve Temizlik", urunGrubu: "Elde Bulaşık Deterjanı", vade: 28, komisyon: 16.00 },
  { kategori: "Süpermarket", altKategori: "Ev Bakım ve Temizlik", urunGrubu: "Yüzey Temizleyici", vade: 28, komisyon: 17.00 },
  // Eski "Temizlik" altKategorisi de 17% ile güncellendi
  { kategori: "Süpermarket", altKategori: "Temizlik", urunGrubu: "Çamaşır Deterjanı", vade: 28, komisyon: 17.00 },
  { kategori: "Süpermarket", altKategori: "Temizlik", urunGrubu: "Bulaşık Deterjanı", vade: 28, komisyon: 16.00 },
  { kategori: "Süpermarket", altKategori: "Temizlik", urunGrubu: "Yüzey Temizleyici", vade: 28, komisyon: 17.00 },
  { kategori: "Süpermarket", altKategori: "Temizlik", urunGrubu: "Temizlik Gereçleri", vade: 28, komisyon: 17.00 },
  { kategori: "Süpermarket", altKategori: "Temizlik", urunGrubu: "Tüy Toplayıcı", vade: 28, komisyon: 17.00 },
  // Diğer
  { kategori: "Süpermarket", altKategori: "Bebek Bakım", urunGrubu: "Bebek Bezi", vade: 28, komisyon: 14.00 },
  { kategori: "Süpermarket", altKategori: "Bebek Bakım", urunGrubu: "Bebek Maması", vade: 28, komisyon: 14.00 },
  { kategori: "Süpermarket", altKategori: "Bebek Bakım", urunGrubu: "Islak Mendil", vade: 28, komisyon: 20.00 },
  { kategori: "Süpermarket", altKategori: "Pet Shop", urunGrubu: "Kedi Maması", vade: 28, komisyon: 16.50 },
  { kategori: "Süpermarket", altKategori: "Pet Shop", urunGrubu: "Köpek Maması", vade: 28, komisyon: 16.50 },
  { kategori: "Süpermarket", altKategori: "Pet Shop", urunGrubu: "Pet Aksesuar", vade: 28, komisyon: 20.00 },
  { kategori: "Süpermarket", altKategori: "Kağıt Ürünleri", urunGrubu: "Tuvalet Kağıdı", vade: 28, komisyon: 20.00 },
  { kategori: "Süpermarket", altKategori: "Kağıt Ürünleri", urunGrubu: "Peçete", vade: 28, komisyon: 20.00 },

  // ===== OTOMOTİV =====
  { kategori: "Otomotiv", altKategori: "Araç Aksesuarları", urunGrubu: "Araç İçi Aksesuar", vade: 21, komisyon: 19.50 },
  { kategori: "Otomotiv", altKategori: "Araç Aksesuarları", urunGrubu: "Araç Dışı Aksesuar", vade: 21, komisyon: 19.50 },
  { kategori: "Otomotiv", altKategori: "Araç Bakım", urunGrubu: "Araç Bakım Ürünleri", vade: 21, komisyon: 19.50 },
  { kategori: "Otomotiv", altKategori: "Yedek Parça", urunGrubu: "Yedek Parça", vade: 21, komisyon: 16.00 },
  { kategori: "Otomotiv", altKategori: "Lastik & Jant", urunGrubu: "Lastik", vade: 21, komisyon: 11.00 },
  { kategori: "Otomotiv", altKategori: "Lastik & Jant", urunGrubu: "Jant", vade: 21, komisyon: 16.00 },
  { kategori: "Otomotiv", altKategori: "Motosiklet", urunGrubu: "Motosiklet Aksesuarları", vade: 21, komisyon: 19.50 },

  // ===== KIRTASİYE & OFİS =====
  { kategori: "Kırtasiye & Ofis", altKategori: "Kırtasiye", urunGrubu: "Defter & Not Defteri", vade: 21, komisyon: 21.50 },
  { kategori: "Kırtasiye & Ofis", altKategori: "Kırtasiye", urunGrubu: "Kalem", vade: 21, komisyon: 21.50 },
  { kategori: "Kırtasiye & Ofis", altKategori: "Kırtasiye", urunGrubu: "Okul Çantası", vade: 21, komisyon: 21.50 },
  { kategori: "Kırtasiye & Ofis", altKategori: "Ofis", urunGrubu: "Ofis Malzemeleri", vade: 21, komisyon: 21.50 },
  { kategori: "Kırtasiye & Ofis", altKategori: "Ofis", urunGrubu: "Yazıcı Kartuş & Toner", vade: 21, komisyon: 19.50 },

  // ===== KİTAP & HOBI =====
  { kategori: "Kitap & Hobi", altKategori: "Kitap", urunGrubu: "Roman", vade: 21, komisyon: 21.50 },
  { kategori: "Kitap & Hobi", altKategori: "Kitap", urunGrubu: "Çocuk Kitapları", vade: 21, komisyon: 21.50 },
  { kategori: "Kitap & Hobi", altKategori: "Kitap", urunGrubu: "Eğitim Kitapları", vade: 21, komisyon: 21.50 },
  { kategori: "Kitap & Hobi", altKategori: "Müzik", urunGrubu: "Müzik Aletleri", vade: 21, komisyon: 19.00 },
  { kategori: "Kitap & Hobi", altKategori: "Hobi", urunGrubu: "Puzzle", vade: 21, komisyon: 19.00 },
  { kategori: "Kitap & Hobi", altKategori: "Hobi", urunGrubu: "Maket & Model", vade: 21, komisyon: 19.00 },

  // ===== SAĞLIK =====
  { kategori: "Sağlık", altKategori: "Sağlık", urunGrubu: "Takviye Edici Gıda", vade: 21, komisyon: 20.00 },
  { kategori: "Sağlık", altKategori: "Sağlık", urunGrubu: "Medikal Ürünler", vade: 21, komisyon: 20.00 },
  { kategori: "Sağlık", altKategori: "Sağlık", urunGrubu: "Cinsel Sağlık", vade: 21, komisyon: 20.00 },
  { kategori: "Sağlık", altKategori: "Sağlık", urunGrubu: "Lens & Gözlük", vade: 21, komisyon: 20.00 },
  { kategori: "Sağlık", altKategori: "Eczane", urunGrubu: "Eczane Ürünleri", vade: 21, komisyon: 20.00 },
];

// Varsayılan komisyon oranı (eşleşme bulunamazsa)
const DEFAULT_COMMISSION = 21.50;
const DEFAULT_VADE = 21;
