// Trendyol Kargo Ücretleri Tablosu (Güncel - 29.01.2026)
// KDV Hariç fiyatlar - hesaplamada %20 KDV eklenir
// Kaynak: guncel_kargo_fiyatlari-29012026-133532.pdf + Barem Destek bilgileri
//
// NOT: Bu değerler varsayılan (hardcoded) değerlerdir.
// Panel'den güncel fiyatlar alındığında updateShippingRates() ile güncellenir.

// Barem Destek Kargo Fiyatları (10 desi ve altı gönderiler için)
// Fiyat aralığına göre değişen kargo ücretleri (KDV HARİÇ)
// `let` — panelden güncelleme alınca değiştirilir
let BAREM_SHIPPING = [
  {
    minPrice: 0,
    maxPrice: 149.99,
    label: "0 - 149,99 TL",
    carriers: {
      "TEX-PTT": 34.16,
      "ARAS": 42.91,
      "SÜRAT": 48.74,
      "KOLAY GELSİN": 51.24,
      "DHLeCommerce": 82.91,
      "YK": 104.58
    }
  },
  {
    minPrice: 150,
    maxPrice: 299.99,
    label: "150 - 299,99 TL",
    carriers: {
      "TEX-PTT": 65.83,
      "ARAS": 73.74,
      "SÜRAT": 79.58,
      "KOLAY GELSİN": 82.08,
      "DHLeCommerce": 82.91,
      "YK": 104.58
    }
  },
  {
    minPrice: 300,
    maxPrice: Infinity,
    label: "300 TL ve üzeri",
    carriers: {
      "TEX-PTT": 0,
      "ARAS": 0,
      "SÜRAT": 0,
      "KOLAY GELSİN": 0,
      "DHLeCommerce": 0,
      "YK": 0
    }
  }
];

// Ağırlık Bazlı Kargo Ücretleri (Desi/KG) - KDV HARİÇ
// 10 desi üzeri gönderiler veya barem destek dışı gönderiler için
let WEIGHT_SHIPPING = [
  { minKg: 0, maxKg: 2, ptt: 77.54, aras: 82.08, surat: 79.58, tex: 65.83, dhlEcommerce: 82.91, kolayGelsin: 51.24, yurtici: 104.58, ceva: 594.46 },
  { minKg: 2, maxKg: 3, ptt: 80.23, aras: 85.67, surat: 82.45, tex: 68.54, dhlEcommerce: 85.67, kolayGelsin: 54.12, yurtici: 108.34, ceva: 594.46 },
  { minKg: 3, maxKg: 4, ptt: 82.91, aras: 89.25, surat: 85.33, tex: 71.24, dhlEcommerce: 88.42, kolayGelsin: 57.00, yurtici: 112.10, ceva: 594.46 },
  { minKg: 4, maxKg: 5, ptt: 85.60, aras: 92.84, surat: 88.20, tex: 73.95, dhlEcommerce: 91.18, kolayGelsin: 59.88, yurtici: 115.86, ceva: 594.46 },
  { minKg: 5, maxKg: 6, ptt: 95.45, aras: 103.50, surat: 98.75, tex: 82.50, dhlEcommerce: 101.82, kolayGelsin: 66.88, yurtici: 129.30, ceva: 594.46 },
  { minKg: 6, maxKg: 7, ptt: 105.30, aras: 114.17, surat: 109.30, tex: 91.05, dhlEcommerce: 112.45, kolayGelsin: 73.88, yurtici: 142.74, ceva: 594.46 },
  { minKg: 7, maxKg: 8, ptt: 115.15, aras: 124.83, surat: 119.85, tex: 99.60, dhlEcommerce: 123.09, kolayGelsin: 80.88, yurtici: 156.18, ceva: 594.46 },
  { minKg: 8, maxKg: 9, ptt: 125.00, aras: 135.50, surat: 130.40, tex: 108.15, dhlEcommerce: 133.72, kolayGelsin: 87.88, yurtici: 169.62, ceva: 594.46 },
  { minKg: 9, maxKg: 10, ptt: 134.85, aras: 146.16, surat: 140.95, tex: 116.70, dhlEcommerce: 144.36, kolayGelsin: 94.88, yurtici: 183.06, ceva: 594.46 },
  { minKg: 10, maxKg: 15, ptt: 179.80, aras: 194.88, surat: 187.93, tex: 155.60, dhlEcommerce: 192.48, kolayGelsin: 126.50, yurtici: 244.08, ceva: 594.46 },
  { minKg: 15, maxKg: 20, ptt: 224.75, aras: 243.60, surat: 234.91, tex: 194.50, dhlEcommerce: 240.60, kolayGelsin: 158.12, yurtici: 305.10, ceva: 594.46 },
  { minKg: 20, maxKg: 25, ptt: 269.70, aras: 292.32, surat: 281.89, tex: 233.40, dhlEcommerce: 288.72, kolayGelsin: 189.74, yurtici: 366.12, ceva: 594.46 },
  { minKg: 25, maxKg: 30, ptt: 322.78, aras: 349.68, surat: 337.13, tex: 279.25, dhlEcommerce: 345.48, kolayGelsin: 226.99, yurtici: 438.05, ceva: 551.32 },
  { minKg: 30, maxKg: 50, ptt: 389.50, aras: 422.00, surat: 406.85, tex: 337.10, dhlEcommerce: 417.00, kolayGelsin: 274.10, yurtici: 528.90, ceva: 551.32 },
  { minKg: 50, maxKg: 100, ptt: 456.22, aras: 494.32, surat: 476.57, tex: 394.95, dhlEcommerce: 488.52, kolayGelsin: 321.21, yurtici: 619.75, ceva: 594.46 },
  { minKg: 100, maxKg: 200, ptt: 522.94, aras: 566.64, surat: 546.29, tex: 452.80, dhlEcommerce: 560.04, kolayGelsin: 368.32, yurtici: 710.60, ceva: 637.60 },
  { minKg: 200, maxKg: 300, ptt: 589.66, aras: 638.96, surat: 616.01, tex: 510.65, dhlEcommerce: 631.56, kolayGelsin: 415.43, yurtici: 801.45, ceva: 680.74 },
  { minKg: 300, maxKg: 500, ptt: 659.65, aras: 714.84, surat: 689.16, tex: 571.25, dhlEcommerce: 706.56, kolayGelsin: 464.74, yurtici: 896.52, ceva: 732.58 },
];

// Varsayılan kargo firması
const DEFAULT_CARRIER = "TEX-PTT";

// KDV Oranı
const KDV_RATE = 0.20;

// ═══════════════════════════════════════════════════════════════════
//  PANELden GÜNCEL KARGO FİYATLARI ALMA
//  Panel admin kargo fiyatlarını değiştirdiğinde extension de güncellenir.
//  background.js /api/extension/config'den alıp chrome.storage.local'a yazar.
//  content.js init'te storage'dan okuyup buradaki fonksiyonları çağırır.
// ═══════════════════════════════════════════════════════════════════

/**
 * Panelden gelen güncel kargo oranlarıyla global tabloları güncelle
 * @param {Array} barem - Barem destek tablosu (panel formatı)
 * @param {Array} weight - Desi/KG tablosu (panel formatı)
 */
function updateShippingRates(barem, weight) {
  if (barem && Array.isArray(barem) && barem.length > 0) {
    // Panel'den gelen barem: maxPrice "Infinity" string olabilir → düzelt
    BAREM_SHIPPING = barem.map(tier => ({
      ...tier,
      maxPrice: tier.maxPrice === "Infinity" || tier.maxPrice === null ? Infinity : tier.maxPrice,
    }));
    console.log("[TK-SHIPPING] Barem tablosu güncellendi:", BAREM_SHIPPING.length, "tier");
  }
  if (weight && Array.isArray(weight) && weight.length > 0) {
    WEIGHT_SHIPPING = weight;
    console.log("[TK-SHIPPING] Weight tablosu güncellendi:", WEIGHT_SHIPPING.length, "tier");
  }
}

// ═══════════════════════════════════════════════════════════════════
//  KATEGORİ BAZLI DESİ TAHMİNİ
//  Panel'deki desi-defaults.js ile aynı mantık.
//  Panelden güncel map alınabilir, yoksa hardcoded varsayılanlar kullanılır.
// ═══════════════════════════════════════════════════════════════════

// Varsayılan kategori-desi eşleme tablosu (panel ile aynı)
let CATEGORY_DESI_MAP = [
  // Elektronik (spesifik)
  { pattern: 'LAPTOP', desi: 6 },
  { pattern: 'BILGISAYAR', desi: 6 },
  { pattern: 'MONITOR', desi: 15 },
  { pattern: 'TABLET', desi: 3 },
  { pattern: 'TELEFON', desi: 2 },
  { pattern: 'KULAKLIK', desi: 2 },
  { pattern: 'KAMERA', desi: 5 },
  { pattern: 'YAZICI', desi: 12 },
  // TV & Ses
  { pattern: 'TELEVIZYON', desi: 20 },
  { pattern: 'TV', desi: 20 },
  { pattern: 'SOUNDBAR', desi: 8 },
  { pattern: 'HOPARLOR', desi: 5 },
  // Beyaz Esya
  { pattern: 'BUZDOLABI', desi: 50 },
  { pattern: 'CAMASIR MAKINESI', desi: 45 },
  { pattern: 'BULASIK MAKINESI', desi: 40 },
  { pattern: 'FIRIN', desi: 25 },
  { pattern: 'KLIMA', desi: 20 },
  { pattern: 'BEYAZ ESYA', desi: 30 },
  // Küçük Ev Aletleri
  { pattern: 'ELEKTRIKLI SUPURGE', desi: 10 },
  { pattern: 'ROBOT SUPURGE', desi: 8 },
  { pattern: 'UTU', desi: 4 },
  { pattern: 'TOST MAKINESI', desi: 5 },
  { pattern: 'MIKSER', desi: 5 },
  { pattern: 'BLENDER', desi: 5 },
  { pattern: 'KAHVE MAKINESI', desi: 6 },
  { pattern: 'KUCUK EV ALETLERI', desi: 5 },
  { pattern: 'ISITICI', desi: 8 },
  { pattern: 'VANTILATÖR', desi: 8 },
  // Mobilya
  { pattern: 'KOLTUK', desi: 40 },
  { pattern: 'KANEPE', desi: 50 },
  { pattern: 'YATAK', desi: 35 },
  { pattern: 'DOLAP', desi: 40 },
  { pattern: 'MASA', desi: 20 },
  { pattern: 'SANDALYE', desi: 12 },
  { pattern: 'RAF', desi: 10 },
  { pattern: 'KITAPLIK', desi: 15 },
  { pattern: 'MOBILYA', desi: 20 },
  // Giyim
  { pattern: 'MONT', desi: 4 },
  { pattern: 'KABAN', desi: 4 },
  { pattern: 'CEKET', desi: 3 },
  { pattern: 'TAKIM ELBISE', desi: 4 },
  { pattern: 'ELBISE', desi: 2 },
  { pattern: 'PANTOLON', desi: 2 },
  { pattern: 'JEAN', desi: 2 },
  { pattern: 'GOMLEK', desi: 2 },
  { pattern: 'TISORT', desi: 1 },
  { pattern: 'T-SHIRT', desi: 1 },
  { pattern: 'SWEATSHIRT', desi: 2 },
  { pattern: 'KAZAK', desi: 2 },
  { pattern: 'IC GIYIM', desi: 1 },
  { pattern: 'PIJAMA', desi: 2 },
  { pattern: 'GIYIM', desi: 2 },
  // Ayakkabı
  { pattern: 'BOT', desi: 4 },
  { pattern: 'CIZME', desi: 4 },
  { pattern: 'SNEAKER', desi: 4 },
  { pattern: 'SPOR AYAKKABI', desi: 4 },
  { pattern: 'TOPUKLU', desi: 3 },
  { pattern: 'SANDALET', desi: 3 },
  { pattern: 'TERLIK', desi: 2 },
  { pattern: 'AYAKKABI', desi: 3 },
  // Çanta
  { pattern: 'VALIZ', desi: 15 },
  { pattern: 'SIRT CANTASI', desi: 5 },
  { pattern: 'CANTA', desi: 3 },
  // Kozmetik
  { pattern: 'PARFUM', desi: 1 },
  { pattern: 'MAKYAJ', desi: 1 },
  { pattern: 'CILT BAKIMI', desi: 1 },
  { pattern: 'SAC BAKIMI', desi: 2 },
  { pattern: 'KOZMETIK', desi: 2 },
  { pattern: 'KISISEL BAKIM', desi: 2 },
  // Kitap & Kırtasiye
  { pattern: 'KITAP', desi: 2 },
  { pattern: 'KIRTASIYE', desi: 3 },
  // Spor
  { pattern: 'BISIKLET', desi: 25 },
  { pattern: 'KOSU BANDI', desi: 40 },
  { pattern: 'AGIRLIK', desi: 10 },
  { pattern: 'SPOR EKIPMANI', desi: 8 },
  { pattern: 'SPOR', desi: 4 },
  // Oyuncak
  { pattern: 'OYUNCAK', desi: 4 },
  { pattern: 'PUZZLE', desi: 3 },
  { pattern: 'LEGO', desi: 4 },
  // Bebek
  { pattern: 'BEBEK ARABASI', desi: 15 },
  { pattern: 'MAMA SANDALYESI', desi: 12 },
  { pattern: 'BEBEK', desi: 4 },
  // Ev & Yaşam
  { pattern: 'HALI', desi: 8 },
  { pattern: 'PERDE', desi: 3 },
  { pattern: 'NEVRESIM', desi: 5 },
  { pattern: 'YORGAN', desi: 8 },
  { pattern: 'YASTIK', desi: 4 },
  { pattern: 'HAVLU', desi: 3 },
  { pattern: 'EV TEKSTILI', desi: 4 },
  { pattern: 'MUTFAK', desi: 3 },
  { pattern: 'BANYO', desi: 3 },
  { pattern: 'DEKORASYON', desi: 4 },
  { pattern: 'AYDINLATMA', desi: 5 },
  // Bahçe
  { pattern: 'BAHCE', desi: 10 },
  // Otomotiv
  { pattern: 'LASTIK', desi: 15 },
  { pattern: 'OTOMOTIV', desi: 8 },
  // Pet
  { pattern: 'PET SHOP', desi: 4 },
  { pattern: 'MAMA', desi: 5 },
  // Genel
  { pattern: 'ELEKTRONIK', desi: 3 },
  { pattern: 'AKSESUAR', desi: 1 },
  { pattern: 'SAAT', desi: 1 },
  { pattern: 'TAKI', desi: 1 },
  { pattern: 'GIDA', desi: 3 },
  { pattern: 'SUPERMARKET', desi: 3 },
];

/**
 * Panelden gelen kategori-desi map ile güncelle
 * @param {Array} map - [{pattern, desi}, ...] formatında
 */
function setDesiDefaults(map) {
  if (map && Array.isArray(map) && map.length > 0) {
    CATEGORY_DESI_MAP = map;
    console.log("[TK-SHIPPING] Desi defaults güncellendi:", CATEGORY_DESI_MAP.length, "pattern");
  }
}

/**
 * Kategori path'inden desi tahmini yap (panel ile aynı mantık)
 * @param {string|null} categoryPath - Örnek: "Elektronik > Bilgisayar > Laptop"
 * @returns {number} Tahmini desi değeri
 */
function estimateDesiFromCategory(categoryPath) {
  if (!categoryPath) return 3; // varsayılan

  // Türkçe karakterleri ASCII'ye normalize et (pattern'ler ASCII)
  const upper = categoryPath
    .toUpperCase()
    .replace(/İ/g, 'I').replace(/Ğ/g, 'G').replace(/Ü/g, 'U')
    .replace(/Ş/g, 'S').replace(/Ö/g, 'O').replace(/Ç/g, 'C')
    .replace(/ı/g, 'I').replace(/ğ/g, 'G').replace(/ü/g, 'U')
    .replace(/ş/g, 'S').replace(/ö/g, 'O').replace(/ç/g, 'C');

  for (const entry of CATEGORY_DESI_MAP) {
    if (upper.includes(entry.pattern)) {
      return entry.desi;
    }
  }

  return 3; // bilinmeyen kategori varsayılanı
}
