// Popup Ayarları + Panel Auth Yönetimi

const defaults = {
  carrier: "TEX-PTT",
  kdvRate: 20
};

// Ayarları yükle
document.addEventListener("DOMContentLoaded", () => {
  chrome.storage.sync.get(defaults, (settings) => {
    document.getElementById("carrier").value = settings.carrier;
    document.getElementById("kdvRate").value = settings.kdvRate;
  });

  // Panel auth durumunu yükle
  loadPanelAuth();
});

// Kaydet
document.getElementById("saveBtn").addEventListener("click", () => {
  const settings = {
    carrier: document.getElementById("carrier").value,
    kdvRate: parseInt(document.getElementById("kdvRate").value) || 20
  };

  chrome.storage.sync.set(settings, () => {
    const msg = document.getElementById("savedMsg");
    msg.style.display = "block";
    setTimeout(() => {
      msg.style.display = "none";
    }, 2000);

    // Aktif Trendyol sekmesine mesaj gönder
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      if (tabs[0] && tabs[0].url && tabs[0].url.includes("trendyol.com")) {
        chrome.tabs.reload(tabs[0].id);
      }
    });
  });
});

function escHtml(str) {
  const div = document.createElement("div");
  div.textContent = str;
  return div.innerHTML;
}

// ─── PANEL AUTH YÖNETİMİ ─────────────────────────────

function loadPanelAuth() {
  chrome.runtime.sendMessage({ action: "GET_PANEL_AUTH" }, (resp) => {
    if (chrome.runtime.lastError) return;
    updatePanelAuthUI(resp && resp.auth ? resp.auth : null);
  });
}

// Plan etiket ve renk mapping
const PLAN_DISPLAY = {
  butik:     { label: "Butik",      color: "#64748b", bg: "#f1f5f9" },
  star:      { label: "Star",       color: "#2563eb", bg: "#eff6ff" },
  girisimci: { label: "Girişimci",  color: "#ea580c", bg: "#fff7ed" },
  // Geriye uyumluluk
  free:      { label: "Butik",      color: "#64748b", bg: "#f1f5f9" },
  pro:       { label: "Girişimci",  color: "#ea580c", bg: "#fff7ed" },
};

function updatePanelAuthUI(auth) {
  const loginForm = document.getElementById("panelLoginForm");
  const loggedIn = document.getElementById("panelLoggedIn");
  const authStatus = document.getElementById("panelAuthStatus");

  if (auth && auth.token) {
    // Giriş yapılmış
    loginForm.style.display = "none";
    loggedIn.style.display = "block";
    document.getElementById("panelUserName").textContent = auth.name || "Kullanıcı";
    document.getElementById("panelUserEmail").textContent = auth.email || "";

    const planKey = auth.plan || "butik";
    const pd = PLAN_DISPLAY[planKey] || PLAN_DISPLAY.butik;
    const planEl = document.getElementById("panelUserPlan");
    planEl.textContent = pd.label + " Plan";
    planEl.style.color = pd.color;
    planEl.style.background = pd.bg;
    planEl.style.padding = "1px 8px";
    planEl.style.borderRadius = "4px";
    planEl.style.display = "inline-block";

    authStatus.innerHTML = '<span style="color:#00b365;font-size:11px">✅ Panel\'e bağlı</span>';
  } else {
    // Giriş yapılmamış
    loginForm.style.display = "block";
    loggedIn.style.display = "none";
    authStatus.innerHTML = '<span style="color:#888;font-size:11px">Giriş yapılmadı</span>';
  }
}

// Login butonu
document.getElementById("panelLoginBtn").addEventListener("click", () => {
  const email = document.getElementById("panelEmail").value.trim();
  const password = document.getElementById("panelPassword").value;
  const errorEl = document.getElementById("panelLoginError");
  const loginBtn = document.getElementById("panelLoginBtn");

  if (!email || !password) {
    errorEl.textContent = "E-posta ve şifre gerekli";
    errorEl.style.display = "block";
    return;
  }

  loginBtn.disabled = true;
  loginBtn.textContent = "Giriş yapılıyor...";
  errorEl.style.display = "none";

  chrome.runtime.sendMessage({
    action: "PANEL_LOGIN",
    email,
    password
  }, (resp) => {
    loginBtn.disabled = false;
    loginBtn.textContent = "Giriş Yap";

    if (chrome.runtime.lastError) {
      errorEl.textContent = "Bağlantı hatası";
      errorEl.style.display = "block";
      return;
    }

    if (resp && resp.status === "ok") {
      updatePanelAuthUI({
        token: true, // UI icin yeterli
        name: resp.user.name,
        email: resp.user.email,
        plan: resp.user.plan,
      });
      // Giriş alanlarını temizle
      document.getElementById("panelPassword").value = "";
    } else {
      errorEl.textContent = (resp && resp.error) || "Giriş başarısız";
      errorEl.style.display = "block";
    }
  });
});

// Logout butonu
document.getElementById("panelLogoutBtn").addEventListener("click", () => {
  chrome.runtime.sendMessage({ action: "PANEL_LOGOUT" }, () => {
    updatePanelAuthUI(null);
  });
});

// Enter ile giriş
document.getElementById("panelPassword").addEventListener("keydown", (e) => {
  if (e.key === "Enter") {
    document.getElementById("panelLoginBtn").click();
  }
});
