// ============================================================
// TK Karlılık Hesaplayıcı - Trendyol Ürün Listesi Bookmarklet
// Kullanım: Trendyol liste/arama sayfasında F12 > Console'a yapıştırın
// Tekrar çalıştırınca tabloyu kapatır.
// ============================================================

(function() {
  "use strict";

  // Zaten açıksa kapat
  if (document.getElementById("tk-overlay")) {
    document.getElementById("tk-overlay").remove();
    return;
  }

  // ===== VERİ: Komisyon Oranları =====
  var COMMS = [
    { kategori: "Aksesuar", altKategori: "Altın", urunGrubu: "İşlenmemiş", vade: 21, komisyon: 9.00 },
    { kategori: "Aksesuar", altKategori: "Altın", urunGrubu: "İşlenmiş", vade: 21, komisyon: 9.00 },
    { kategori: "Aksesuar", altKategori: "Mücevher", urunGrubu: "Mücevher", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Atkı & Bere & Eldiven", urunGrubu: "Atkı & Bere & Eldiven", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Gözlük", urunGrubu: "Güneş Gözlüğü", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Gözlük", urunGrubu: "Optik Gözlük", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Saat", urunGrubu: "Kol Saati", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Saat", urunGrubu: "Akıllı Saat", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Şapka & Kep", urunGrubu: "Şapka & Kep", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Kemer", urunGrubu: "Kemer", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Cüzdan", urunGrubu: "Cüzdan", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Takı", urunGrubu: "Kolye", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Takı", urunGrubu: "Bileklik", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Takı", urunGrubu: "Küpe", vade: 21, komisyon: 21.50 },
    { kategori: "Aksesuar", altKategori: "Takı", urunGrubu: "Yüzük", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Kadın Ayakkabı", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Erkek Ayakkabı", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Çocuk Ayakkabı", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Spor Ayakkabı", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Sneaker", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Bot", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Sandalet", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Terlik", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Ayakkabı", urunGrubu: "Topuklu Ayakkabı", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Çanta", urunGrubu: "Kadın Çanta", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Çanta", urunGrubu: "Erkek Çanta", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Çanta", urunGrubu: "Sırt Çantası", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Çanta", urunGrubu: "Bavul & Valiz", vade: 21, komisyon: 21.50 },
    { kategori: "Ayakkabı & Çanta", altKategori: "Çanta", urunGrubu: "El Çantası", vade: 21, komisyon: 21.50 },
    { kategori: "Yapı Market & Bahçe", altKategori: "Bahçe", urunGrubu: "Bahçe Aydınlatması", vade: 21, komisyon: 20.50 },
    { kategori: "Yapı Market & Bahçe", altKategori: "Bahçe", urunGrubu: "Bahçe Makineleri", vade: 21, komisyon: 16.00 },
    { kategori: "Yapı Market & Bahçe", altKategori: "Bahçe", urunGrubu: "Bahçe Mobilyası", vade: 21, komisyon: 20.50 },
    { kategori: "Yapı Market & Bahçe", altKategori: "Bahçe", urunGrubu: "Bahçe Süsleme", vade: 21, komisyon: 20.50 },
    { kategori: "Yapı Market & Bahçe", altKategori: "Elektrikli El Aletleri", urunGrubu: "Elektrikli El Aletleri", vade: 21, komisyon: 16.50 },
    { kategori: "Yapı Market & Bahçe", altKategori: "Hırdavat", urunGrubu: "Hırdavat", vade: 21, komisyon: 20.50 },
    { kategori: "Yapı Market & Bahçe", altKategori: "Boya & Yapı Kimyasalları", urunGrubu: "Boya", vade: 21, komisyon: 20.50 },
    { kategori: "Yapı Market & Bahçe", altKategori: "Tesisat", urunGrubu: "Tesisat Malzemeleri", vade: 21, komisyon: 20.50 },
    { kategori: "Elektronik", altKategori: "Akıllı Ev", urunGrubu: "Akıllı Aydınlatma Ürünleri", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Akıllı Ev", urunGrubu: "Akıllı Ev Sistemleri", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Telefon", urunGrubu: "Smartphone Android", vade: 14, komisyon: 7.00 },
    { kategori: "Elektronik", altKategori: "Telefon", urunGrubu: "Smartphone iOS", vade: 14, komisyon: 7.00 },
    { kategori: "Elektronik", altKategori: "Telefon", urunGrubu: "Cep Telefonu", vade: 14, komisyon: 7.00 },
    { kategori: "Elektronik", altKategori: "Telefon Aksesuarları", urunGrubu: "Telefon Kılıfı", vade: 14, komisyon: 21.50 },
    { kategori: "Elektronik", altKategori: "Telefon Aksesuarları", urunGrubu: "Şarj Aleti", vade: 14, komisyon: 21.50 },
    { kategori: "Elektronik", altKategori: "Telefon Aksesuarları", urunGrubu: "Ekran Koruyucu", vade: 14, komisyon: 21.50 },
    { kategori: "Elektronik", altKategori: "Telefon Aksesuarları", urunGrubu: "Kulaklık", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Telefon Aksesuarları", urunGrubu: "Powerbank", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Beyaz Eşya", urunGrubu: "Buzdolabı", vade: 14, komisyon: 15.00 },
    { kategori: "Elektronik", altKategori: "Beyaz Eşya", urunGrubu: "Çamaşır Makinesi", vade: 14, komisyon: 15.00 },
    { kategori: "Elektronik", altKategori: "Beyaz Eşya", urunGrubu: "Bulaşık Makinesi", vade: 14, komisyon: 15.00 },
    { kategori: "Elektronik", altKategori: "Beyaz Eşya", urunGrubu: "Fırın", vade: 14, komisyon: 15.00 },
    { kategori: "Elektronik", altKategori: "TV", urunGrubu: "Televizyon", vade: 14, komisyon: 15.00 },
    { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Laptop", vade: 14, komisyon: 11.00 },
    { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Masaüstü Bilgisayar", vade: 14, komisyon: 11.00 },
    { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Tablet", vade: 14, komisyon: 11.00 },
    { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Bilgisayar Aksesuarları", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Monitör", vade: 14, komisyon: 11.00 },
    { kategori: "Elektronik", altKategori: "Bilgisayar", urunGrubu: "Yazıcı", vade: 14, komisyon: 11.00 },
    { kategori: "Elektronik", altKategori: "Klima", urunGrubu: "Klima", vade: 14, komisyon: 11.00 },
    { kategori: "Elektronik", altKategori: "Klima", urunGrubu: "Isıtıcı", vade: 14, komisyon: 15.00 },
    { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Ütü", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Elektrikli Süpürge", vade: 14, komisyon: 15.00 },
    { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Çay Makinesi", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Kahve Makinesi", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Robot Süpürge", vade: 14, komisyon: 15.00 },
    { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Blender", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Mutfak Robotu", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Tost Makinesi", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Saç Kurutma", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Küçük Ev Aletleri", urunGrubu: "Saç Düzleştirici", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Kamera", urunGrubu: "Fotoğraf Makinesi", vade: 14, komisyon: 11.00 },
    { kategori: "Elektronik", altKategori: "Kamera", urunGrubu: "Aksiyon Kamera", vade: 14, komisyon: 11.00 },
    { kategori: "Elektronik", altKategori: "Kamera", urunGrubu: "Güvenlik Kamerası", vade: 14, komisyon: 19.50 },
    { kategori: "Elektronik", altKategori: "Oyun", urunGrubu: "Oyun Konsolu", vade: 14, komisyon: 11.00 },
    { kategori: "Elektronik", altKategori: "Oyun", urunGrubu: "Oyun Aksesuarları", vade: 14, komisyon: 19.50 },
    { kategori: "Çocuk & Bebek", altKategori: "Bebek", urunGrubu: "Bebek Arabası", vade: 21, komisyon: 19.00 },
    { kategori: "Çocuk & Bebek", altKategori: "Bebek", urunGrubu: "Bebek Gereçleri", vade: 21, komisyon: 19.00 },
    { kategori: "Çocuk & Bebek", altKategori: "Bebek", urunGrubu: "Bebek Bezi", vade: 21, komisyon: 14.00 },
    { kategori: "Çocuk & Bebek", altKategori: "Bebek", urunGrubu: "Bebek Bakım", vade: 21, komisyon: 19.00 },
    { kategori: "Çocuk & Bebek", altKategori: "Bebek", urunGrubu: "Bebek Giyim", vade: 21, komisyon: 21.50 },
    { kategori: "Çocuk & Bebek", altKategori: "Çocuk", urunGrubu: "Çocuk Giyim", vade: 21, komisyon: 21.50 },
    { kategori: "Çocuk & Bebek", altKategori: "Çocuk", urunGrubu: "Çocuk Ayakkabı", vade: 21, komisyon: 21.50 },
    { kategori: "Çocuk & Bebek", altKategori: "Oyuncak", urunGrubu: "Oyuncak Genel", vade: 21, komisyon: 19.00 },
    { kategori: "Çocuk & Bebek", altKategori: "Oyuncak", urunGrubu: "Oyuncak Ahşap", vade: 21, komisyon: 19.00 },
    { kategori: "Çocuk & Bebek", altKategori: "Oyuncak", urunGrubu: "Eğitici Oyuncak", vade: 21, komisyon: 19.00 },
    { kategori: "Çocuk & Bebek", altKategori: "Çocuk Gereçleri", urunGrubu: "Çocuk Gereçleri", vade: 21, komisyon: 19.00 },
    { kategori: "Çocuk & Bebek", altKategori: "Oto Koltuğu", urunGrubu: "Oto Koltuğu", vade: 3, komisyon: 19.00 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Elbise", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Bluz", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Gömlek", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Tişört", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Pantolon", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Jean", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Etek", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Ceket", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Mont", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Kazak", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Kadın Giyim", urunGrubu: "Sweatshirt", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Tişört", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Gömlek", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Pantolon", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Mont", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Erkek Giyim", urunGrubu: "Sweatshirt", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Spor Giyim", urunGrubu: "Spor Giyim", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "İç Giyim", urunGrubu: "Kadın İç Giyim", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "İç Giyim", urunGrubu: "Erkek İç Giyim", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "İç Giyim", urunGrubu: "Pijama", vade: 21, komisyon: 21.50 },
    { kategori: "Giyim", altKategori: "Mayo & Bikini", urunGrubu: "Mayo & Bikini", vade: 21, komisyon: 21.50 },
    { kategori: "Ev & Mobilya", altKategori: "Mobilya", urunGrubu: "Salon Mobilyası", vade: 28, komisyon: 23.00 },
    { kategori: "Ev & Mobilya", altKategori: "Mobilya", urunGrubu: "Yatak Odası", vade: 28, komisyon: 23.00 },
    { kategori: "Ev & Mobilya", altKategori: "Mobilya", urunGrubu: "Ofis Mobilyası", vade: 28, komisyon: 23.00 },
    { kategori: "Ev & Mobilya", altKategori: "Ev Tekstili", urunGrubu: "Nevresim", vade: 21, komisyon: 21.50 },
    { kategori: "Ev & Mobilya", altKategori: "Ev Tekstili", urunGrubu: "Halı", vade: 21, komisyon: 21.50 },
    { kategori: "Ev & Mobilya", altKategori: "Mutfak", urunGrubu: "Tencere & Tava", vade: 21, komisyon: 21.50 },
    { kategori: "Ev & Mobilya", altKategori: "Mutfak", urunGrubu: "Mutfak Gereçleri", vade: 21, komisyon: 21.50 },
    { kategori: "Ev & Mobilya", altKategori: "Dekorasyon", urunGrubu: "Duvar Dekorasyon", vade: 21, komisyon: 21.50 },
    { kategori: "Ev & Mobilya", altKategori: "Aydınlatma", urunGrubu: "Avize", vade: 21, komisyon: 20.50 },
    { kategori: "Ev & Mobilya", altKategori: "Banyo", urunGrubu: "Banyo Aksesuarları", vade: 21, komisyon: 21.50 },
    { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Makyaj", urunGrubu: "Ruj", vade: 21, komisyon: 21.50 },
    { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Cilt Bakımı", urunGrubu: "Nemlendirici", vade: 21, komisyon: 21.50 },
    { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Saç Bakımı", urunGrubu: "Şampuan", vade: 21, komisyon: 21.50 },
    { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Parfüm", urunGrubu: "Kadın Parfüm", vade: 21, komisyon: 21.50 },
    { kategori: "Kozmetik & Kişisel Bakım", altKategori: "Kişisel Bakım", urunGrubu: "Diş Bakımı", vade: 21, komisyon: 20.00 },
    { kategori: "Spor & Outdoor", altKategori: "Spor Giyim", urunGrubu: "Spor Tişört", vade: 21, komisyon: 21.50 },
    { kategori: "Spor & Outdoor", altKategori: "Spor Ekipman", urunGrubu: "Fitness Ekipmanı", vade: 21, komisyon: 19.00 },
    { kategori: "Spor & Outdoor", altKategori: "Spor Ekipman", urunGrubu: "Bisiklet", vade: 21, komisyon: 16.00 },
    { kategori: "Spor & Outdoor", altKategori: "Spor Ekipman", urunGrubu: "Kamp Malzemeleri", vade: 21, komisyon: 19.00 },
    { kategori: "Spor & Outdoor", altKategori: "Spor Ayakkabı", urunGrubu: "Koşu Ayakkabısı", vade: 21, komisyon: 21.50 },
    { kategori: "Süpermarket", altKategori: "Gıda", urunGrubu: "Atıştırmalık", vade: 21, komisyon: 18.00 },
    { kategori: "Süpermarket", altKategori: "Gıda", urunGrubu: "Bakliyat & Makarna", vade: 21, komisyon: 13.00 },
    { kategori: "Süpermarket", altKategori: "İçecek", urunGrubu: "Çay", vade: 21, komisyon: 18.00 },
    { kategori: "Süpermarket", altKategori: "Temizlik", urunGrubu: "Çamaşır Deterjanı", vade: 21, komisyon: 20.00 },
    { kategori: "Süpermarket", altKategori: "Bebek Bakım", urunGrubu: "Bebek Bezi", vade: 21, komisyon: 14.00 },
    { kategori: "Süpermarket", altKategori: "Pet Shop", urunGrubu: "Kedi Maması", vade: 21, komisyon: 16.50 },
    { kategori: "Otomotiv", altKategori: "Araç Aksesuarları", urunGrubu: "Araç İçi Aksesuar", vade: 21, komisyon: 19.50 },
    { kategori: "Otomotiv", altKategori: "Araç Bakım", urunGrubu: "Araç Bakım Ürünleri", vade: 21, komisyon: 19.50 },
    { kategori: "Otomotiv", altKategori: "Yedek Parça", urunGrubu: "Yedek Parça", vade: 21, komisyon: 16.00 },
    { kategori: "Otomotiv", altKategori: "Lastik & Jant", urunGrubu: "Lastik", vade: 21, komisyon: 11.00 },
    { kategori: "Otomotiv", altKategori: "Lastik & Jant", urunGrubu: "Jant", vade: 21, komisyon: 16.00 },
    { kategori: "Kırtasiye & Ofis", altKategori: "Kırtasiye", urunGrubu: "Kalem", vade: 21, komisyon: 21.50 },
    { kategori: "Kırtasiye & Ofis", altKategori: "Ofis", urunGrubu: "Ofis Malzemeleri", vade: 21, komisyon: 21.50 },
    { kategori: "Kitap & Hobi", altKategori: "Kitap", urunGrubu: "Roman", vade: 21, komisyon: 21.50 },
    { kategori: "Kitap & Hobi", altKategori: "Hobi", urunGrubu: "Puzzle", vade: 21, komisyon: 19.00 },
    { kategori: "Sağlık", altKategori: "Sağlık", urunGrubu: "Takviye Edici Gıda", vade: 21, komisyon: 20.00 },
    { kategori: "Sağlık", altKategori: "Sağlık", urunGrubu: "Medikal Ürünler", vade: 21, komisyon: 20.00 },
    { kategori: "Sağlık", altKategori: "Eczane", urunGrubu: "Eczane Ürünleri", vade: 21, komisyon: 20.00 }
  ];

  var DEFAULT_COMMISSION = 21.50;
  var DEFAULT_VADE = 21;

  // ===== VERİ: Kargo =====
  var BAREM_SHIPPING = [
    { minPrice: 0, maxPrice: 149.99, label: "0-149,99 TL", carriers: { "TEX-PTT": 34.16, "ARAS": 42.91, "SÜRAT": 48.74, "KOLAY GELSİN": 51.24, "DHLeCommerce": 82.91, "YK": 104.58 } },
    { minPrice: 150, maxPrice: 299.99, label: "150-299,99 TL", carriers: { "TEX-PTT": 65.83, "ARAS": 73.74, "SÜRAT": 79.58, "KOLAY GELSİN": 82.08, "DHLeCommerce": 82.91, "YK": 104.58 } },
    { minPrice: 300, maxPrice: Infinity, label: "300+ TL (Ücretsiz)", carriers: { "TEX-PTT": 0, "ARAS": 0, "SÜRAT": 0, "KOLAY GELSİN": 0, "DHLeCommerce": 0, "YK": 0 } }
  ];

  // 3 desi kargo fiyatları (KDV hariç) - 300 TL üzeri ürünlerde uygulanır
  var DESI3_SHIPPING = { "TEX-PTT": 71.24, "ARAS": 89.25, "SÜRAT": 85.33, "KOLAY GELSİN": 57.00, "DHLeCommerce": 88.42, "YK": 112.10 };

  var KDV_RATE = 0.20;
  var HIZMET_BEDELI = 10.20;
  var CARRIER = "TEX-PTT";
  var SALES_MULTIPLIER = 5;

  // Manuel override değerleri
  var MANUAL = { kargo: null, kdvRate: null, satisAdedi: null, maliyet: null };

  // ===== Aylık Satış Tahmini =====
  function estimateMonthlySales(reviewCount, rating, price) {
    if (reviewCount <= 0) return 3;
    var totalSales = reviewCount * 5;
    var monthly = totalSales / 6;

    var ratingMult = 1.0;
    if (rating <= 0)       ratingMult = 1.0;
    else if (rating >= 4.5) ratingMult = 1.3;
    else if (rating >= 4.0) ratingMult = 1.0;
    else if (rating >= 3.5) ratingMult = 0.6;
    else if (rating >= 3.0) ratingMult = 0.3;
    else                     ratingMult = 0.1;

    var priceMult = 1.0;
    if (price <= 50)        priceMult = 1.5;
    else if (price <= 150)  priceMult = 1.0;
    else if (price <= 300)  priceMult = 0.7;
    else if (price <= 500)  priceMult = 0.5;
    else                     priceMult = 0.3;

    monthly = monthly * ratingMult * priceMult;
    return Math.max(1, Math.round(monthly));
  }

  // ===== Yardımcı Fonksiyonlar =====
  function parsePrice(str) {
    if (!str) return 0;
    if (typeof str === 'number') return str;
    str = String(str).trim();
    // TL ile biten ilk fiyat bloğunu bul (birleşik metin koruması)
    var tlBlocks = str.match(/[\d.,\s]+TL/gi);
    if (tlBlocks && tlBlocks.length > 0) {
      var block = tlBlocks[0].replace(/TL/i, "").trim();
      var kuruslu = block.match(/^([\d.]+),(\d{2})$/);
      if (kuruslu) {
        var v = parseFloat(kuruslu[1].replace(/\./g, "") + "." + kuruslu[2]);
        if (v > 0) return v;
      }
      var tam = block.match(/^[\d.]+$/);
      if (tam) {
        var v2 = parseFloat(block.replace(/\./g, ""));
        if (v2 > 0) return v2;
      }
    }
    // Kuruşlu fiyat fallback
    var km = str.match(/([\d.]+),(\d{2})/);
    if (km) {
      var v3 = parseFloat(km[1].replace(/\./g, "") + "." + km[2]);
      if (v3 > 0) return v3;
    }
    // Son fallback
    var cleaned = str.replace(/[^\d.,]/g, "").replace(/\./g, "").replace(",", ".");
    var v4 = parseFloat(cleaned);
    return (v4 > 0 && v4 < 1000000) ? v4 : 0;
  }

  function formatPrice(n) {
    if (n == null || isNaN(n)) return "-";
    return n.toLocaleString("tr-TR", { minimumFractionDigits: 2, maximumFractionDigits: 2 }) + " TL";
  }

  function formatPercent(n) {
    if (n == null || isNaN(n)) return "-";
    return "%" + n.toLocaleString("tr-TR", { minimumFractionDigits: 1, maximumFractionDigits: 1 });
  }

  // ===== Komisyon Eşleştirme =====
  function findCommission(breadcrumbs) {
    if (!breadcrumbs || breadcrumbs.length === 0) {
      return { komisyon: DEFAULT_COMMISSION, vade: DEFAULT_VADE, match: "Varsayılan" };
    }
    var searchTerms = breadcrumbs.map(function(b) { return b.toLowerCase().trim(); }).filter(function(b) { return b && b !== "trendyol"; });
    var bestMatch = null, bestScore = 0;

    for (var i = 0; i < COMMS.length; i++) {
      var item = COMMS[i];
      var itemTerms = [item.kategori.toLowerCase(), item.altKategori.toLowerCase(), item.urunGrubu.toLowerCase()];
      var score = 0;

      for (var s = 0; s < searchTerms.length; s++) {
        for (var t = 0; t < itemTerms.length; t++) {
          if (searchTerms[s] === itemTerms[t]) score += 10;
          else if (itemTerms[t].indexOf(searchTerms[s]) >= 0 || searchTerms[s].indexOf(itemTerms[t]) >= 0) score += 5;
          else {
            var sw = searchTerms[s].split(/\s+/);
            var iw = itemTerms[t].split(/\s+/);
            for (var a = 0; a < sw.length; a++) {
              for (var b = 0; b < iw.length; b++) {
                if (sw[a] === iw[b] && sw[a].length > 2) score += 3;
                else if ((sw[a].indexOf(iw[b]) >= 0 || iw[b].indexOf(sw[a]) >= 0) && Math.min(sw[a].length, iw[b].length) > 2) score += 1;
              }
            }
          }
        }
      }
      if (score > bestScore) { bestScore = score; bestMatch = item; }
    }

    if (bestMatch && bestScore > 0) {
      return { komisyon: bestMatch.komisyon, vade: bestMatch.vade, match: bestMatch.kategori + " > " + bestMatch.altKategori + " > " + bestMatch.urunGrubu };
    }
    return { komisyon: DEFAULT_COMMISSION, vade: DEFAULT_VADE, match: "Varsayılan" };
  }

  // ===== Kargo (300 TL üzeri 3 desi uygulanır) =====
  function getShippingCost(salePrice) {
    if (MANUAL.kargo !== null) return { total: MANUAL.kargo, tier: "Manuel" };

    for (var i = 0; i < BAREM_SHIPPING.length; i++) {
      var tier = BAREM_SHIPPING[i];
      if (salePrice >= tier.minPrice && salePrice <= tier.maxPrice) {
        var keys = Object.keys(tier.carriers);
        var matchedKey = keys.find(function(k) { return k === CARRIER; }) || keys[0];
        var basePrice = tier.carriers[matchedKey];
        // 300 TL üzeri: 3 desi kargo fiyatı uygula
        if (salePrice >= 300 && basePrice === 0) {
          var desi3Base = DESI3_SHIPPING[CARRIER] || DESI3_SHIPPING["TEX-PTT"];
          return { total: desi3Base * (1 + KDV_RATE), tier: "3 desi (300+ TL)" };
        }
        return { total: basePrice * (1 + KDV_RATE), tier: tier.label };
      }
    }
    return { total: 0, tier: "Ücretsiz" };
  }

  // ===== Breadcrumbs =====
  function getBreadcrumbs() {
    var bcEls = document.querySelectorAll(".breadcrumb a, .product-detail-breadcrumbs-item a");
    var bc = [];
    bcEls.forEach(function(el) {
      var t = el.textContent.trim();
      if (t && t !== "Trendyol") bc.push(t);
    });
    if (bc.length > 0) return bc;

    var parts = window.location.pathname.split("/").filter(function(p) { return p && p !== "sr"; });
    return parts.map(function(p) {
      return p.replace(/-x-.*$/, "").replace(/-c\d+$/, "").replace(/-/g, " ");
    });
  }

  // ===== Ürünleri Tara (Yeni Trendyol yapısı: a.product-card) =====
  function scrapeProducts() {
    // Hem yeni hem eski yapıyı destekle
    var cards = document.querySelectorAll("a.product-card");
    if (cards.length === 0) {
      cards = document.querySelectorAll(".p-card-wrppr, [class*='p-card']");
    }

    var products = [];
    var breadcrumbs = getBreadcrumbs();

    cards.forEach(function(card, idx) {
      // Fiyat: yeni yapı (.sale-price) veya eski yapı (.prc-box-dscntd)
      var priceEl = card.querySelector(".sale-price") ||
                    card.querySelector(".prc-box-dscntd") ||
                    card.querySelector(".prc-box-sllng") ||
                    card.querySelector("[class*='prc-box']");
      if (!priceEl) return;
      var price = parsePrice(priceEl.textContent);
      if (!price) return;

      // Marka + İsim: yeni yapı (.product-brand, .product-name) veya eski (.prdct-desc-cntnr-ttl, .prdct-desc-cntnr-name)
      var brandEl = card.querySelector(".product-brand") || card.querySelector(".prdct-desc-cntnr-ttl");
      var nameEl = card.querySelector(".product-name") || card.querySelector(".prdct-desc-cntnr-name");
      var brand = brandEl ? brandEl.textContent.trim() : "";
      var name = nameEl ? nameEl.textContent.trim() : "";
      var fullName = (brand ? brand + " " : "") + (name || "Ürün " + (idx + 1));

      // Yorum sayısı: yeni yapı (.total-count) veya eski ([class*='ratingCount'])
      var rcEl = card.querySelector(".total-count") || card.querySelector("[class*='ratingCount']");
      var reviewCount = 0;
      if (rcEl) {
        var m = rcEl.textContent.match(/(\d+)/);
        reviewCount = m ? parseInt(m[0]) : 0;
      }

      // Puan: yeni yapı (.average-rating) veya eski ([class*='ratingScore'])
      var ratEl = card.querySelector(".average-rating") || card.querySelector("[class*='ratingScore']");
      var rating = ratEl ? parseFloat(ratEl.textContent) : 0;

      // Link
      var link = card.href || "";
      if (!link) {
        var linkEl = card.querySelector("a[href]");
        link = linkEl ? linkEl.href : "";
      }

      if (idx >= 50) return; // Max 50 ürün

      // Hesapla
      var commInfo = findCommission(breadcrumbs);
      var commRate = commInfo.komisyon;
      var commAmount = price * (commRate / 100);
      var shipping = getShippingCost(price);
      var kdvRate = MANUAL.kdvRate !== null ? MANUAL.kdvRate / 100 : KDV_RATE;
      var estSales = MANUAL.satisAdedi !== null ? MANUAL.satisAdedi : estimateMonthlySales(reviewCount, rating, price);
      var kalanKDVDahil = price - commAmount - HIZMET_BEDELI - shipping.total;
      var kdvAmount = kalanKDVDahil - (kalanKDVDahil / (1 + kdvRate));
      var kalanKDVHaric = kalanKDVDahil - kdvAmount;
      var usedCost = MANUAL.maliyet !== null ? MANUAL.maliyet : kalanKDVHaric / 1.20;
      var profit = kalanKDVHaric - usedCost;
      var monthlyProfit = profit * estSales;

      products.push({
        idx: idx + 1,
        name: fullName.substring(0, 65),
        price: price,
        rating: rating,
        reviewCount: reviewCount,
        link: link,
        commRate: commRate,
        commAmount: commAmount,
        commMatch: commInfo.match,
        shipTotal: shipping.total,
        shipTier: shipping.tier,
        kalanKDVDahil: kalanKDVDahil,
        kdvAmount: kdvAmount,
        kalanKDVHaric: kalanKDVHaric,
        autoEstCost: usedCost,
        profit: profit,
        estSales: estSales,
        monthlyProfit: monthlyProfit,
        origShipTotal: shipping.total,
        origShipTier: shipping.tier,
        origEstSales: estSales,
        origAutoEstCost: usedCost,
        rowOverrides: { kargo: null, kdvRate: null, maliyet: null, satisAdedi: null }
      });
    });

    return products;
  }

  // ===== CSV Export =====
  function exportCSV(products) {
    var BOM = "\uFEFF";
    var headers = ["#","Ürün Adı","Fiyat","Puan","Yorum","Komisyon %","Komisyon TL","Kargo","Hizmet","Kalan(KDV D.)","KDV","Kalan(KDV H.)","Maks.Maliyet","Kâr/Satış","Ay.Satış","Aylık Kâr","Link"];
    var rows = products.map(function(p) {
      return [p.idx, '"' + p.name.replace(/"/g, '""') + '"', p.price.toFixed(2), p.rating > 0 ? p.rating.toFixed(1) : "",
        p.reviewCount || "", p.commRate.toFixed(1), p.commAmount.toFixed(2), p.shipTotal.toFixed(2), "10.20",
        p.kalanKDVDahil.toFixed(2), p.kdvAmount.toFixed(2), p.kalanKDVHaric.toFixed(2), p.autoEstCost.toFixed(2),
        p.profit.toFixed(2), p.estSales, p.monthlyProfit.toFixed(2), p.link || ""].join(";");
    });
    var csv = BOM + headers.join(";") + "\n" + rows.join("\n");
    var blob = new Blob([csv], { type: "text/csv;charset=utf-8;" });
    var url = URL.createObjectURL(blob);
    var a = document.createElement("a");
    a.href = url; a.download = "trendyol_karlilik_" + new Date().toISOString().slice(0, 10) + ".csv";
    a.click(); URL.revokeObjectURL(url);
  }

  // ===== Tablo Göster =====
  function showTable(products) {
    var overlay = document.createElement("div");
    overlay.id = "tk-overlay";
    overlay.style.cssText = "position:fixed;top:0;left:0;right:0;bottom:0;z-index:999999;background:rgba(0,0,0,0.93);overflow-y:auto;font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;";

    var html = '<div style="max-width:1500px;margin:20px auto;padding:0 16px;">' +
      '<div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:16px;flex-wrap:wrap;gap:12px;">' +
      '<div><h2 style="color:#f27a1a;font-size:22px;margin:0 0 4px 0;">TK Karlılık Hesaplayıcı</h2>' +
      '<span id="tk-subtitle" style="font-size:13px;color:#aaa;">' + products.length + ' ürün bulundu | Kargo: ' + CARRIER + ' | Kategori: ' + products[0].commMatch + '</span></div>' +
      '<div style="display:flex;gap:8px;align-items:center;">' +
      '<select id="tk-carrier-sel" style="padding:8px 12px;border-radius:6px;border:1px solid #555;background:#333;color:#fff;font-size:13px;">' +
      '<option value="TEX-PTT"' + (CARRIER === "TEX-PTT" ? " selected" : "") + '>TEX-PTT (En Ucuz)</option>' +
      '<option value="ARAS"' + (CARRIER === "ARAS" ? " selected" : "") + '>Aras Kargo</option>' +
      '<option value="SÜRAT"' + (CARRIER === "SÜRAT" ? " selected" : "") + '>Sürat Kargo</option>' +
      '<option value="KOLAY GELSİN"' + (CARRIER === "KOLAY GELSİN" ? " selected" : "") + '>Kolay Gelsin</option>' +
      '<option value="DHLeCommerce"' + (CARRIER === "DHLeCommerce" ? " selected" : "") + '>DHL eCommerce</option>' +
      '<option value="YK"' + (CARRIER === "YK" ? " selected" : "") + '>Yurtiçi Kargo</option>' +
      '</select>' +
      '<button id="tk-export-btn" style="padding:10px 20px;border-radius:8px;border:none;background:#27ae60;color:#fff;font-weight:700;cursor:pointer;font-size:13px;">Excel (CSV)</button>' +
      '<button id="tk-close-btn" style="padding:10px 28px;border-radius:8px;border:none;background:#e53e3e;color:#fff;font-weight:700;cursor:pointer;font-size:15px;">Kapat (ESC)</button>' +
      '</div></div>' +

      // Manuel giriş paneli
      '<div style="display:flex;align-items:flex-end;gap:12px;margin-bottom:12px;padding:12px 16px;background:rgba(255,255,255,0.08);border-radius:8px;border:1px solid rgba(255,255,255,0.12);flex-wrap:wrap;">' +
      '<div style="display:flex;flex-direction:column;gap:4px;"><label style="font-size:11px;color:#aaa;font-weight:600;">Kargo (TL)</label>' +
      '<input type="number" id="tk-m-kargo" placeholder="Otomatik" step="0.01" min="0" style="width:110px;padding:6px 10px;border-radius:6px;border:1px solid #555;background:#2a2a2a;color:#fff;font-size:13px;" value="' + (MANUAL.kargo !== null ? MANUAL.kargo : '') + '"></div>' +
      '<div style="display:flex;flex-direction:column;gap:4px;"><label style="font-size:11px;color:#aaa;font-weight:600;">KDV (%)</label>' +
      '<input type="number" id="tk-m-kdv" placeholder="20" step="1" min="0" max="50" style="width:110px;padding:6px 10px;border-radius:6px;border:1px solid #555;background:#2a2a2a;color:#fff;font-size:13px;" value="' + (MANUAL.kdvRate !== null ? MANUAL.kdvRate : '') + '"></div>' +
      '<div style="display:flex;flex-direction:column;gap:4px;"><label style="font-size:11px;color:#aaa;font-weight:600;">Ay. Satış (adet)</label>' +
      '<input type="number" id="tk-m-satis" placeholder="Otomatik" step="1" min="0" style="width:110px;padding:6px 10px;border-radius:6px;border:1px solid #555;background:#2a2a2a;color:#fff;font-size:13px;" value="' + (MANUAL.satisAdedi !== null ? MANUAL.satisAdedi : '') + '"></div>' +
      '<div style="display:flex;flex-direction:column;gap:4px;"><label style="font-size:11px;color:#aaa;font-weight:600;">Maliyet (TL)</label>' +
      '<input type="number" id="tk-m-maliyet" placeholder="Tahmini" step="0.01" min="0" style="width:110px;padding:6px 10px;border-radius:6px;border:1px solid #555;background:#2a2a2a;color:#fff;font-size:13px;" value="' + (MANUAL.maliyet !== null ? MANUAL.maliyet : '') + '"></div>' +
      '<button id="tk-m-apply" style="padding:6px 18px;border-radius:6px;border:none;background:#f27a1a;color:#fff;font-weight:700;cursor:pointer;font-size:13px;height:33px;">Uygula</button>' +
      '<button id="tk-m-reset" style="padding:6px 14px;border-radius:6px;border:1px solid #666;background:transparent;color:#aaa;font-weight:600;cursor:pointer;font-size:12px;height:33px;">Sıfırla</button>' +
      '</div>' +

      '<div style="overflow-x:auto;border-radius:10px;box-shadow:0 4px 20px rgba(0,0,0,0.3);">' +
      '<table id="tk-table" style="width:100%;border-collapse:collapse;font-size:12px;background:#fff;min-width:1200px;">' +
      '<thead><tr style="background:linear-gradient(135deg,#f27a1a,#ff6000);color:#fff;">' +
      '<th style="padding:12px 8px;font-size:11px;text-align:center;white-space:nowrap;">#</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:left;min-width:220px;">Ürün Adı</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:right;white-space:nowrap;cursor:pointer;" data-sort="price">Fiyat ↕</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:center;white-space:nowrap;">Puan</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:center;white-space:nowrap;">Yorum</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:right;white-space:nowrap;">Komisyon</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:right;white-space:nowrap;">Kargo</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:right;white-space:nowrap;">Hizmet</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:right;white-space:nowrap;">Kalan(KDV D.)</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:right;white-space:nowrap;">KDV</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:right;white-space:nowrap;background:rgba(255,255,255,0.15);cursor:pointer;" data-sort="kalanKDVHaric">Kalan(KDV H.) ↕</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:right;white-space:nowrap;">Maks.Maliyet</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:right;white-space:nowrap;background:rgba(255,255,255,0.15);cursor:pointer;" data-sort="profit">Kâr/Satış ↕</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:center;white-space:nowrap;">Ay.Satış</th>' +
      '<th style="padding:12px 8px;font-size:11px;text-align:right;white-space:nowrap;background:rgba(255,255,255,0.15);cursor:pointer;" data-sort="monthlyProfit">Aylık Kâr ↕</th>' +
      '</tr></thead><tbody id="tk-tbody"></tbody></table></div></div>';

    overlay.innerHTML = html;
    document.body.appendChild(overlay);
    renderRows(products);

    // Kapat butonu
    document.getElementById("tk-close-btn").addEventListener("click", function() { overlay.remove(); });

    // Excel export
    document.getElementById("tk-export-btn").addEventListener("click", function() { exportCSV(products); });

    // Manuel giriş - Uygula (üst panel = global varsayılan, satır override'ları korunur)
    document.getElementById("tk-m-apply").addEventListener("click", function() {
      var k = document.getElementById("tk-m-kargo").value;
      var v = document.getElementById("tk-m-kdv").value;
      var s = document.getElementById("tk-m-satis").value;
      var m = document.getElementById("tk-m-maliyet").value;
      MANUAL.kargo = k !== "" ? parseFloat(k) : null;
      MANUAL.kdvRate = v !== "" ? parseFloat(v) : null;
      MANUAL.satisAdedi = s !== "" ? parseInt(s) : null;
      MANUAL.maliyet = m !== "" ? parseFloat(m) : null;
      for (var i = 0; i < products.length; i++) recalcRow(products, i);
      renderRows(products);
    });

    // Manuel giriş - Sıfırla (üst panel + tüm satır override'ları temizlenir)
    document.getElementById("tk-m-reset").addEventListener("click", function() {
      MANUAL = { kargo: null, kdvRate: null, satisAdedi: null, maliyet: null };
      document.getElementById("tk-m-kargo").value = "";
      document.getElementById("tk-m-kdv").value = "";
      document.getElementById("tk-m-satis").value = "";
      document.getElementById("tk-m-maliyet").value = "";
      for (var i = 0; i < products.length; i++) {
        products[i].rowOverrides = { kargo: null, kdvRate: null, maliyet: null, satisAdedi: null };
        recalcRow(products, i);
      }
      renderRows(products);
    });

    // Kargo değiştir
    document.getElementById("tk-carrier-sel").addEventListener("change", function() {
      CARRIER = this.value;
      for (var i = 0; i < products.length; i++) recalcRow(products, i);
      renderRows(products);
    });

    // Sıralama
    var sortDir = {};
    document.getElementById("tk-table").querySelectorAll("th[data-sort]").forEach(function(th) {
      th.addEventListener("click", function() {
        var key = th.getAttribute("data-sort");
        sortDir[key] = sortDir[key] === "asc" ? "desc" : "asc";
        var dir = sortDir[key];
        products.sort(function(a, b) {
          var va = a[key];
          var vb = b[key];
          return dir === "asc" ? va - vb : vb - va;
        });
        renderRows(products);
      });
    });

    // ESC ile kapat
    document.addEventListener("keydown", function escHandler(e) {
      if (e.key === "Escape") {
        overlay.remove();
        document.removeEventListener("keydown", escHandler);
      }
    });
  }

  // Tek satır yeniden hesaplama
  function recalcRow(products, idx) {
    var p = products[idx];
    if (!p) return;

    // Kargo: satır override > üst panel > otomatik
    if (p.rowOverrides.kargo !== null) {
      p.shipTotal = p.rowOverrides.kargo;
      p.shipTier = "Manuel (satır)";
    } else if (MANUAL.kargo !== null) {
      p.shipTotal = MANUAL.kargo;
      p.shipTier = "Manuel";
    } else {
      var shipping = getShippingCost(p.price);
      p.shipTotal = shipping.total;
      p.shipTier = shipping.tier;
    }

    // KDV oranı: satır override > üst panel > varsayılan
    var kdvPct = p.rowOverrides.kdvRate !== null ? p.rowOverrides.kdvRate
      : MANUAL.kdvRate !== null ? MANUAL.kdvRate : 20;
    var kdvRate = kdvPct / 100;

    // Satış adedi: satır override > üst panel > akıllı tahmin
    p.estSales = p.rowOverrides.satisAdedi !== null ? p.rowOverrides.satisAdedi
      : MANUAL.satisAdedi !== null ? MANUAL.satisAdedi
      : estimateMonthlySales(p.reviewCount, p.rating, p.price);

    p.kalanKDVDahil = p.price - p.commAmount - HIZMET_BEDELI - p.shipTotal;
    p.kdvAmount = p.kalanKDVDahil - (p.kalanKDVDahil / (1 + kdvRate));
    p.kalanKDVHaric = p.kalanKDVDahil - p.kdvAmount;

    // Maliyet: satır override > üst panel > tahmini
    p.autoEstCost = p.rowOverrides.maliyet !== null ? p.rowOverrides.maliyet
      : MANUAL.maliyet !== null ? MANUAL.maliyet
      : p.kalanKDVHaric / 1.20;

    p.profit = p.kalanKDVHaric - p.autoEstCost;
    p.monthlyProfit = p.profit * p.estSales;

    // DOM güncelle
    updateRowCells(p, idx);
  }

  function updateRowCells(p, idx) {
    var row = document.querySelector('#tk-tbody tr[data-idx="' + idx + '"]');
    if (!row) return;
    var profitColor = p.profit >= 0 ? "#00b365" : "#e53e3e";
    var kalanColor = p.kalanKDVHaric >= 0 ? "#00b365" : "#e53e3e";
    var monthlyColor = p.monthlyProfit >= 0 ? "#00b365" : "#e53e3e";

    var cells = row.querySelectorAll("td");
    var kargoResult = cells[6].querySelector(".tk-bm-kargo-result");
    if (kargoResult) kargoResult.innerHTML = '-' + formatPrice(p.shipTotal) + '<br><span style="font-size:10px;color:#999;">' + p.shipTier + '</span>';

    cells[8].innerHTML = formatPrice(p.kalanKDVDahil);
    var kdvDiv = cells[9].querySelector("div");
    if (kdvDiv) kdvDiv.innerHTML = '-' + formatPrice(p.kdvAmount);
    cells[10].style.color = kalanColor;
    cells[10].innerHTML = formatPrice(p.kalanKDVHaric);

    var maliyetResult = cells[11].querySelector(".tk-bm-maliyet-result");
    if (maliyetResult) maliyetResult.textContent = formatPrice(p.autoEstCost);

    cells[12].style.color = profitColor;
    cells[12].innerHTML = formatPrice(p.profit);

    var satisResult = cells[13].querySelector(".tk-bm-satis-result");
    if (satisResult) satisResult.textContent = p.estSales;

    cells[14].style.color = monthlyColor;
    cells[14].innerHTML = formatPrice(p.monthlyProfit);
  }

  function renderRows(products) {
    var tbody = document.getElementById("tk-tbody");
    if (!tbody) return;
    var inputStyle = 'width:68px;padding:3px 5px;border:none;border-bottom:1.5px solid #ddd;background:transparent;color:#333;font-size:11px;text-align:right;outline:none;margin-bottom:2px;display:block;';
    var inputSmStyle = inputStyle + 'width:48px;';
    var editedExtra = 'border-bottom-color:#f27a1a;color:#f27a1a;font-weight:700;background:#fff8f0;';
    var html = "";
    for (var i = 0; i < products.length; i++) {
      var p = products[i];
      var bgColor = i % 2 === 0 ? "#fff" : "#f9f9f9";
      var profitColor = p.profit >= 0 ? "#00b365" : "#e53e3e";
      var kalanColor = p.kalanKDVHaric >= 0 ? "#00b365" : "#e53e3e";
      var monthlyColor = p.monthlyProfit >= 0 ? "#00b365" : "#e53e3e";

      var kargoVal = p.rowOverrides.kargo !== null ? p.rowOverrides.kargo : "";
      var maliyetVal = p.rowOverrides.maliyet !== null ? p.rowOverrides.maliyet : "";
      var satisVal = p.rowOverrides.satisAdedi !== null ? p.rowOverrides.satisAdedi : "";
      var kdvVal = p.rowOverrides.kdvRate !== null ? p.rowOverrides.kdvRate : "";

      html += '<tr data-idx="' + i + '" style="background:' + bgColor + ';border-bottom:1px solid #eee;">' +
        '<td style="padding:8px;color:#999;text-align:center;font-size:11px;">' + p.idx + '</td>' +
        '<td style="padding:8px;">' + (p.link ? '<a href="' + p.link + '" target="_blank" style="color:#333;text-decoration:none;">' : '') +
        '<div style="font-weight:600;max-width:220px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;" title="' + p.name + '">' + p.name + '</div>' + (p.link ? '</a>' : '') + '</td>' +
        '<td style="padding:8px;text-align:right;font-weight:700;color:#f27a1a;white-space:nowrap;">' + formatPrice(p.price) + '</td>' +
        '<td style="padding:8px;text-align:center;color:#666;">' + (p.rating > 0 ? p.rating.toFixed(1) : "-") + '</td>' +
        '<td style="padding:8px;text-align:center;color:#666;">' + (p.reviewCount || "-") + '</td>' +
        '<td style="padding:8px;text-align:right;color:#e53e3e;white-space:nowrap;font-size:11px;">' + formatPercent(p.commRate) + '<br><span style="font-size:10px;">-' + formatPrice(p.commAmount) + '</span></td>' +
        '<td style="padding:8px;text-align:right;color:#e53e3e;white-space:nowrap;font-size:11px;">' +
          '<input type="number" class="tk-bm-row-input" data-field="kargo" data-row="' + i + '" placeholder="' + p.shipTotal.toFixed(1) + '" value="' + kargoVal + '" step="0.1" min="0" title="Kargo (TL)" style="' + inputStyle + (kargoVal !== "" ? editedExtra : "") + '">' +
          '<div class="tk-bm-kargo-result">-' + formatPrice(p.shipTotal) + '<br><span style="font-size:10px;color:#999;">' + p.shipTier + '</span></div></td>' +
        '<td style="padding:8px;text-align:right;color:#e53e3e;white-space:nowrap;font-size:11px;">-' + formatPrice(HIZMET_BEDELI) + '</td>' +
        '<td style="padding:8px;text-align:right;white-space:nowrap;font-size:11px;">' + formatPrice(p.kalanKDVDahil) + '</td>' +
        '<td style="padding:8px;text-align:right;color:#e53e3e;white-space:nowrap;font-size:11px;">' +
          '<input type="number" class="tk-bm-row-input" data-field="kdvRate" data-row="' + i + '" placeholder="' + (p.rowOverrides.kdvRate !== null ? p.rowOverrides.kdvRate : MANUAL.kdvRate !== null ? MANUAL.kdvRate : 20) + '" value="' + kdvVal + '" step="1" min="0" max="50" title="KDV (%)" style="' + inputSmStyle + (kdvVal !== "" ? editedExtra : "") + '">' +
          '<div>-' + formatPrice(p.kdvAmount) + '</div></td>' +
        '<td style="padding:8px;text-align:right;font-weight:700;color:' + kalanColor + ';white-space:nowrap;">' + formatPrice(p.kalanKDVHaric) + '</td>' +
        '<td style="padding:8px;text-align:right;color:#666;white-space:nowrap;font-size:11px;">' +
          '<input type="number" class="tk-bm-row-input" data-field="maliyet" data-row="' + i + '" placeholder="' + p.autoEstCost.toFixed(1) + '" value="' + maliyetVal + '" step="0.1" min="0" title="Maliyet (TL)" style="' + inputStyle + (maliyetVal !== "" ? editedExtra : "") + '">' +
          '<div class="tk-bm-maliyet-result">' + formatPrice(p.autoEstCost) + '</div></td>' +
        '<td style="padding:8px;text-align:right;font-weight:700;color:' + profitColor + ';white-space:nowrap;">' + formatPrice(p.profit) + '</td>' +
        '<td style="padding:8px;text-align:center;color:#666;">' +
          '<input type="number" class="tk-bm-row-input" data-field="satisAdedi" data-row="' + i + '" placeholder="' + p.estSales + '" value="' + satisVal + '" step="1" min="0" title="Aylık Satış Adedi" style="' + inputSmStyle + (satisVal !== "" ? editedExtra : "") + '">' +
          '<div class="tk-bm-satis-result" style="color:#666;font-size:11px;">' + p.estSales + '</div></td>' +
        '<td style="padding:8px;text-align:right;font-weight:700;font-size:13px;color:' + monthlyColor + ';white-space:nowrap;">' + formatPrice(p.monthlyProfit) + '</td></tr>';
    }
    tbody.innerHTML = html;

    // Satır inputlarına event listener
    tbody.querySelectorAll(".tk-bm-row-input").forEach(function(input) {
      input.addEventListener("change", function() {
        var row = parseInt(this.getAttribute("data-row"));
        var field = this.getAttribute("data-field");
        var val = this.value;
        products[row].rowOverrides[field] = val !== "" ? parseFloat(val) : null;
        if (val !== "") {
          this.style.borderBottomColor = "#f27a1a";
          this.style.color = "#f27a1a";
          this.style.fontWeight = "700";
          this.style.background = "#fff8f0";
        } else {
          this.style.borderBottomColor = "#ddd";
          this.style.color = "#333";
          this.style.fontWeight = "normal";
          this.style.background = "transparent";
        }
        recalcRow(products, row);
      });
    });
  }

  // ===== Auto-scroll ile ürün yükle (min 20, max 50) =====
  async function autoScrollAndRun() {
    // Loading göster (pointer-events:none ile sayfanın scroll'unu engelleme)
    var loadDiv = document.createElement("div");
    loadDiv.id = "tk-loading";
    loadDiv.style.cssText = "position:fixed;top:0;left:0;right:0;bottom:0;z-index:999999;background:rgba(0,0,0,0.85);display:flex;align-items:center;justify-content:center;flex-direction:column;pointer-events:none;font-family:-apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,sans-serif;";
    loadDiv.innerHTML = '<div style="width:48px;height:48px;border:5px solid #333;border-top-color:#f27a1a;border-radius:50%;animation:tk-spin 0.8s linear infinite;margin-bottom:20px;"></div>' +
      '<h2 style="color:#f27a1a;font-size:22px;margin:0 0 8px 0;">Ürünler taranıyor...</h2>' +
      '<p id="tk-load-count" style="color:#aaa;font-size:14px;">Sayfa aşağı kaydırılarak daha fazla ürün yükleniyor</p>' +
      '<style>@keyframes tk-spin{to{transform:rotate(360deg)}}</style>';
    document.body.appendChild(loadDiv);

    var MIN = 20, MAX = 50, MAX_ATTEMPTS = 25;
    var lastCount = 0, sameRounds = 0;

    for (var attempt = 0; attempt < MAX_ATTEMPTS; attempt++) {
      var cards = document.querySelectorAll("a.product-card, .p-card-wrppr, [class*='p-card']");
      var cnt = cards.length;
      var el = document.getElementById("tk-load-count");
      if (el) el.textContent = cnt + " ürün bulundu... Daha fazlası yükleniyor";
      if (cnt >= MAX) break;
      if (cnt >= MIN && sameRounds >= 3) break;
      if (sameRounds >= 4) break;
      if (cnt === lastCount) sameRounds++; else sameRounds = 0;
      lastCount = cnt;
      window.scrollBy(0, window.innerHeight * 2);
      await new Promise(function(r) { setTimeout(r, 800); });
      window.scrollTo({ top: document.body.scrollHeight, behavior: "smooth" });
      await new Promise(function(r) { setTimeout(r, 1500); });
    }

    window.scrollTo({ top: 0, behavior: "smooth" });
    loadDiv.remove();

    var products = scrapeProducts();
    if (products.length === 0) {
      alert("Bu sayfada ürün kartı bulunamadı!\nTrendyol ürün listesi veya arama sayfasında deneyin.");
      return;
    }
    showTable(products);
  }

  autoScrollAndRun();
})();
